/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.a;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static final String TAG = "ZIP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean decompressZipFolder(String zipFileString, String outPathString) {
        if (TextUtils.isEmpty((CharSequence)zipFileString) || TextUtils.isEmpty((CharSequence)outPathString)) {
            return false;
        }
        String temporaryPath = outPathString + System.currentTimeMillis();
        ZipInputStream inZip = null;
        try {
            ZipEntry zipEntry;
            inZip = new ZipInputStream(new FileInputStream(zipFileString));
            while ((zipEntry = inZip.getNextEntry()) != null) {
                int len;
                String canonicalPath;
                String szName = zipEntry.getName();
                if (TextUtils.isEmpty((CharSequence)szName) || szName.contains("../")) {
                    boolean bl = false;
                    return bl;
                }
                if (zipEntry.isDirectory()) {
                    a.a().d(TAG, "directory name === " + temporaryPath + File.separator + szName);
                    File folder = new File(temporaryPath + File.separator + szName);
                    canonicalPath = folder.getCanonicalPath();
                    if (TextUtils.isEmpty((CharSequence)canonicalPath) || canonicalPath.contains("../")) continue;
                    folder.mkdirs();
                    continue;
                }
                a.a().d(TAG, "file name === " + temporaryPath + File.separator + szName);
                File file = new File(temporaryPath + File.separator + szName);
                canonicalPath = file.getCanonicalPath();
                if (TextUtils.isEmpty((CharSequence)canonicalPath) || canonicalPath.contains("../")) continue;
                if (!file.exists()) {
                    a.a().d(TAG, "Create the file:" + temporaryPath + File.separator + szName);
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = inZip.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                    out.flush();
                }
                out.close();
            }
            File temporaryFile = new File(temporaryPath);
            File outFile = new File(outPathString);
            if (temporaryFile.exists()) {
                temporaryFile.renameTo(outFile);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (inZip != null) {
                try {
                    inZip.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        return true;
    }
}

