/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.database;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.util.TimeUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.ConfigCodeSeatDTO;
import com.cloud.hisavana.sdk.database.a;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.google.gson.reflect.TypeToken;
import com.transsion.core.CoreUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class HisavanaContentProvider
extends ContentProvider {
    private String a;
    private UriMatcher b;
    private SQLiteDatabase c;

    private void a() {
        if (this.b == null) {
            this.a = this.getContext().getPackageName() + ".HisavanaContentProvider";
            this.b = new UriMatcher(-1);
            this.b.addURI(this.a, "config", 100);
            this.b.addURI(this.a, "ad_data", 200);
        }
    }

    public boolean onCreate() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreUtil.init((Context)HisavanaContentProvider.this.getContext());
                    int initType = AdxPreferencesHelper.getInstance().getInt("IS_DEBUG", -1);
                    if (initType != -1) {
                        AthenaTracker.init(initType == 0, HisavanaContentProvider.this.getContext());
                    }
                }
                catch (Exception exception) {
                    com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", Log.getStackTraceString((Throwable)exception));
                }
            }
        }, 5000L);
        this.a();
        return false;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        this.b();
        Cursor cursor = null;
        try {
            cursor = this.c.rawQuery(selection, null);
        }
        catch (Exception e2) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", Log.getStackTraceString((Throwable)e2));
        }
        return cursor;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "insert " + uri + " " + this.b.match(uri));
        boolean isSuccess = false;
        String path = "";
        try {
            this.b();
            if (this.b.match(uri) == 100) {
                String content;
                path = "config";
                if (values != null && !TextUtils.isEmpty((CharSequence)(content = values.getAsString("CloudConfig")))) {
                    Type type = new TypeToken<List<ConfigCodeSeatDTO>>(){}.getType();
                    List list = (List)GsonUtil.fromJson((String)content, (Type)type);
                    isSuccess = this.d(list);
                }
            } else if (this.b.match(uri) == 200) {
                String content;
                path = "ad_data";
                if (values != null && !TextUtils.isEmpty((CharSequence)(content = values.getAsString("AdsData")))) {
                    Type type = new TypeToken<List<AdsDTO>>(){}.getType();
                    List adsDTOList = (List)GsonUtil.fromJson((String)content, (Type)type);
                    isSuccess = this.a(adsDTOList);
                }
            } else {
                com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "insert,uri is wrong");
            }
        }
        catch (Exception e2) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", Log.getStackTraceString((Throwable)e2));
        }
        return Uri.parse((String)("content://" + this.a + "/" + path + "/" + isSuccess));
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "delete ");
        try {
            if (this.b.match(uri) == 200 && selectionArgs != null && selectionArgs.length > 0) {
                StringBuilder param = new StringBuilder("(");
                for (int i2 = 0; i2 < selectionArgs.length; ++i2) {
                    if (i2 == selectionArgs.length - 1) {
                        param.append("'").append(selectionArgs[i2]).append("'");
                        continue;
                    }
                    param.append("'").append(selectionArgs[i2]).append("',");
                }
                param.append(")");
                String sql = "DELETE FROM adList WHERE _id in " + param;
                this.b();
                this.c.execSQL(sql);
            }
        }
        catch (Exception exception) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", "delete " + Log.getStackTraceString((Throwable)exception));
        }
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "update " + values);
        try {
            if (this.b.match(uri) == 100) {
                Type type;
                List list;
                String json = null;
                if (values != null) {
                    json = values.getAsString("CloudConfig");
                }
                if (!TextUtils.isEmpty(json) && (list = (List)GsonUtil.fromJson((String)json, (Type)(type = new TypeToken<List<ConfigCodeSeatDTO>>(){}.getType()))) != null && !list.isEmpty()) {
                    boolean result = this.f(list);
                    return result ? 1 : 0;
                }
            } else if (this.b.match(uri) == 200) {
                Type type;
                List list;
                String json = null;
                if (values != null) {
                    json = values.getAsString("AdsData");
                }
                if (!TextUtils.isEmpty(json) && (list = (List)GsonUtil.fromJson((String)json, (Type)(type = new TypeToken<List<AdsDTO>>(){}.getType()))) != null) {
                    boolean result = this.c(list);
                    return result ? 1 : 0;
                }
            }
        }
        catch (Exception exception) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", "update " + Log.getStackTraceString((Throwable)exception));
        }
        return 0;
    }

    private boolean a(List<AdsDTO> adsDTOList) {
        if (adsDTOList == null || adsDTOList.isEmpty()) {
            com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "insertOrUpdateAds list is null or empty");
            return false;
        }
        int adsLen = adsDTOList.size();
        String[] ids = new String[adsLen];
        for (int i2 = 0; i2 < adsLen; ++i2) {
            AdsDTO ad = adsDTOList.get(i2);
            if (ad == null) continue;
            ids[i2] = String.valueOf(ad.getAdCreativeId());
        }
        Cursor cursor = this.a(ids);
        ArrayList<AdsDTO> queryList = new ArrayList<AdsDTO>();
        ArrayList<AdsDTO> updateList = new ArrayList<AdsDTO>();
        AdsDTO temp = null;
        while (cursor != null && cursor.moveToNext()) {
            String json;
            int jsonIndex = cursor.getColumnIndex("ad_bean");
            if (jsonIndex < 0 || TextUtils.isEmpty((CharSequence)(json = cursor.getString(jsonIndex)))) continue;
            try {
                temp = (AdsDTO)GsonUtil.fromJson((String)json, AdsDTO.class);
                queryList.add(temp);
            }
            catch (GsonUtil.GsonParseException e2) {
                e2.printStackTrace();
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        boolean insertSuccess = false;
        boolean updateSuccess = true;
        if (!queryList.isEmpty()) {
            block4: for (int i3 = adsLen - 1; i3 >= 0; --i3) {
                temp = adsDTOList.get(i3);
                for (int j2 = 0; j2 < queryList.size(); ++j2) {
                    AdsDTO update = (AdsDTO)queryList.get(j2);
                    if (!temp.getAdCreativeId().equals(update.getAdCreativeId()) || !TextUtils.equals((CharSequence)temp.getCodeSeatId(), (CharSequence)update.getCodeSeatId())) continue;
                    temp.setShowDate(update.getShowDate());
                    temp.setShowNum(update.getShowNum());
                    temp.setTableId(update.getTableId());
                    adsDTOList.remove(temp);
                    updateList.add(temp);
                    continue block4;
                }
            }
            updateSuccess = this.c(updateList);
        }
        return (insertSuccess = this.b(adsDTOList)) && updateSuccess;
    }

    private Cursor a(String[] adIds) {
        Cursor cursor = null;
        String sql = "";
        if (adIds == null || adIds.length == 0) {
            sql = "SELECT * FROM adList";
        } else {
            StringBuilder param = new StringBuilder("(");
            for (int i2 = 0; i2 < adIds.length; ++i2) {
                if (i2 == adIds.length - 1) {
                    param.append("'").append(adIds[i2]).append("'");
                    continue;
                }
                param.append("'").append(adIds[i2]).append("',");
            }
            param.append(")");
            sql = "select * from adList where ad_creative_id IN " + param;
        }
        try {
            this.b();
            com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "getCursorForProvider sql " + sql);
            cursor = this.c.rawQuery(sql, null);
        }
        catch (Exception e2) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", "getCursorForProvider e " + Log.getStackTraceString((Throwable)e2));
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b(List<AdsDTO> insertList) {
        if (insertList == null || insertList.isEmpty()) {
            return false;
        }
        this.b();
        try {
            this.c.beginTransaction();
            long current = TimeUtil.getZeroClockTimestamp(System.currentTimeMillis());
            for (AdsDTO adsDTO : insertList) {
                adsDTO.setShowDate(current);
                String json = GsonUtil.toJson((Object)adsDTO);
                ContentValues contentValues = new ContentValues();
                contentValues.put("ad_creative_id", String.valueOf(adsDTO.getAdCreativeId()));
                contentValues.put("codeSeatId", adsDTO.getCodeSeatId());
                contentValues.put("file_path", adsDTO.getFilePath());
                contentValues.put("price", adsDTO.getFirstPrice());
                contentValues.put("ad_bean", json);
                this.c.insert("adList", null, contentValues);
            }
            this.c.setTransactionSuccessful();
        }
        catch (Exception exception) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", "insert Config fail " + Log.getStackTraceString((Throwable)exception));
            boolean bl = false;
            return bl;
        }
        finally {
            this.c.endTransaction();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean c(List<AdsDTO> updateList) {
        if (updateList == null || updateList.isEmpty()) {
            com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "updateAdsList list is empty ");
            return false;
        }
        com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "updateAdsList size " + updateList.size());
        this.b();
        try {
            this.c.beginTransaction();
            for (AdsDTO adsDTO : updateList) {
                String json = GsonUtil.toJson((Object)adsDTO);
                ContentValues contentValues = new ContentValues();
                contentValues.put("ad_bean", json);
                String tableId = String.valueOf(adsDTO.getTableId());
                int result = this.c.update("adList", contentValues, "_id =?", new String[]{tableId});
                com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "updateAdsList result " + result);
            }
            this.c.setTransactionSuccessful();
        }
        catch (Exception exception) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", "insert Config fail " + Log.getStackTraceString((Throwable)exception));
            boolean bl = false;
            return bl;
        }
        finally {
            this.c.endTransaction();
        }
        return true;
    }

    private boolean d(List<ConfigCodeSeatDTO> insertList) {
        com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "insertOrUpdateConfig " + insertList);
        boolean result = false;
        this.b();
        this.c.execSQL("delete from cloudList where 1=1");
        result = this.e(insertList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean e(List<ConfigCodeSeatDTO> insertList) {
        if (insertList == null || insertList.isEmpty()) {
            return false;
        }
        this.b();
        try {
            this.c.beginTransaction();
            for (ConfigCodeSeatDTO config : insertList) {
                String json = GsonUtil.toJson((Object)config);
                ContentValues contentValues = new ContentValues();
                contentValues.put("codeSeatId", config.getCodeSeatId());
                contentValues.put("code_seat_bean", json);
                this.c.insert("cloudList", null, contentValues);
            }
            this.c.setTransactionSuccessful();
        }
        catch (Exception exception) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", "insert Config fail " + Log.getStackTraceString((Throwable)exception));
            boolean bl = false;
            return bl;
        }
        finally {
            this.c.endTransaction();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean f(List<ConfigCodeSeatDTO> updateList) {
        if (updateList == null || updateList.isEmpty()) {
            return false;
        }
        try {
            this.b();
            this.c.beginTransaction();
            for (ConfigCodeSeatDTO config : updateList) {
                String json = GsonUtil.toJson((Object)config);
                ContentValues contentValues = new ContentValues();
                contentValues.put("codeSeatId", config.getCodeSeatId());
                contentValues.put("code_seat_bean", json);
                int result = this.c.update("cloudList", contentValues, "codeSeatId=?", new String[]{config.getCodeSeatId()});
                com.cloud.hisavana.sdk.common.a.a().d("HisavanaContentProvider", "updateConfig result " + result);
            }
            this.c.setTransactionSuccessful();
        }
        catch (Exception exception) {
            com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", "update config fail" + Log.getStackTraceString((Throwable)exception));
            boolean bl = false;
            return bl;
        }
        finally {
            this.c.endTransaction();
        }
        return true;
    }

    private synchronized SQLiteDatabase b() {
        if (this.c == null || !this.c.isOpen()) {
            try {
                a dbHelper = new a(CoreUtil.getContext());
                this.c = dbHelper.getWritableDatabase();
            }
            catch (Exception ex) {
                com.cloud.hisavana.sdk.common.a.a().e("HisavanaContentProvider", "openDB ex " + Log.getStackTraceString((Throwable)ex));
            }
        }
        return this.c;
    }
}

