/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import com.cloud.tupdate.BuildConfig;
import com.cloud.tupdate.TUpdate;
import com.cloud.tupdate.UpdateManager;
import com.cloud.tupdate.download.DownloadManager;
import com.cloud.tupdate.impl.UpdateChecker;
import com.cloud.tupdate.impl.UpdateParser;
import com.cloud.tupdate.impl.UpdatePrompter;
import com.cloud.tupdate.interfaces.IUpdateChecker;
import com.cloud.tupdate.interfaces.IUpdateParser;
import com.cloud.tupdate.interfaces.IUpdatePrompter;
import com.cloud.tupdate.net.network.HttpRequestor;
import com.cloud.tupdate.net.utils.LogUtil;
import com.cloud.tupdate.utils.AthenaUtils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020&H\u0007J\b\u0010'\u001a\u00020\u0000H\u0002J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rJ\b\u0010+\u001a\u00020#H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR(\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lcom/cloud/tupdate/TUpdate;", "", "()V", "mApplication", "Landroid/app/Application;", "mIUpdatePrompter", "Lcom/cloud/tupdate/interfaces/IUpdatePrompter;", "getMIUpdatePrompter", "()Lcom/cloud/tupdate/interfaces/IUpdatePrompter;", "setMIUpdatePrompter", "(Lcom/cloud/tupdate/interfaces/IUpdatePrompter;)V", "mParams", "", "", "getMParams", "()Ljava/util/Map;", "setMParams", "(Ljava/util/Map;)V", "mUpdateChecker", "Lcom/cloud/tupdate/interfaces/IUpdateChecker;", "getMUpdateChecker", "()Lcom/cloud/tupdate/interfaces/IUpdateChecker;", "setMUpdateChecker", "(Lcom/cloud/tupdate/interfaces/IUpdateChecker;)V", "mUpdateParser", "Lcom/cloud/tupdate/interfaces/IUpdateParser;", "getMUpdateParser", "()Lcom/cloud/tupdate/interfaces/IUpdateParser;", "setMUpdateParser", "(Lcom/cloud/tupdate/interfaces/IUpdateParser;)V", "getApplication", "getLanguage", "resources", "Landroid/content/res/Resources;", "init", "", "application", "isAutoInitGateway", "", "initHttpRequest", "param", "key", "value", "testInitialize", "Companion", "tupdate_release"})
public final class TUpdate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Application mApplication;
    @Nullable
    private Map<String, String> mParams;
    @NotNull
    private IUpdateChecker mUpdateChecker = new UpdateChecker();
    @NotNull
    private IUpdateParser mUpdateParser = new UpdateParser();
    @NotNull
    private IUpdatePrompter mIUpdatePrompter = new UpdatePrompter();
    @NotNull
    private static final Lazy<TUpdate> get$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)Companion.get.2.INSTANCE);

    private TUpdate() {
    }

    @Nullable
    public final Map<String, String> getMParams() {
        return this.mParams;
    }

    public final void setMParams(@Nullable Map<String, String> map) {
        this.mParams = map;
    }

    @NotNull
    public final IUpdateChecker getMUpdateChecker() {
        return this.mUpdateChecker;
    }

    public final void setMUpdateChecker(@NotNull IUpdateChecker iUpdateChecker) {
        Intrinsics.checkNotNullParameter((Object)iUpdateChecker, (String)"<set-?>");
        this.mUpdateChecker = iUpdateChecker;
    }

    @NotNull
    public final IUpdateParser getMUpdateParser() {
        return this.mUpdateParser;
    }

    public final void setMUpdateParser(@NotNull IUpdateParser iUpdateParser) {
        Intrinsics.checkNotNullParameter((Object)iUpdateParser, (String)"<set-?>");
        this.mUpdateParser = iUpdateParser;
    }

    @NotNull
    public final IUpdatePrompter getMIUpdatePrompter() {
        return this.mIUpdatePrompter;
    }

    public final void setMIUpdatePrompter(@NotNull IUpdatePrompter iUpdatePrompter) {
        Intrinsics.checkNotNullParameter((Object)iUpdatePrompter, (String)"<set-?>");
        this.mIUpdatePrompter = iUpdatePrompter;
    }

    @JvmOverloads
    public final void init(@NotNull Application application, boolean isAutoInitGateway) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.mApplication = application;
        DownloadManager.init$default(DownloadManager.Companion.getInstance(), (Context)application, 0, 2, null);
        this.initHttpRequest();
        AthenaUtils.INSTANCE.initAthena((Context)this.mApplication);
        Bundle bundle = new Bundle();
        bundle.putInt("upgrade_sdk_init_status", 1);
        AthenaUtils.INSTANCE.trackOtherEvent("upgrade_sdk_init", bundle);
    }

    public static /* synthetic */ void init$default(TUpdate tUpdate, Application application, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        tUpdate.init(application, bl);
    }

    @NotNull
    public final Application getApplication() {
        this.testInitialize();
        Application application = this.mApplication;
        Intrinsics.checkNotNull((Object)application);
        return application;
    }

    private final void testInitialize() {
        if (this.mApplication == null) {
            throw new ExceptionInInitializerError("\u8bf7\u5148\u5728\u5168\u5c40Application\u4e2d\u8c03\u7528 TUpdate.get().init() \u521d\u59cb\u5316\uff01");
        }
    }

    @NotNull
    public final TUpdate param(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.mParams == null) {
            this.mParams = new LinkedHashMap();
        }
        Map<String, String> map = this.mParams;
        Intrinsics.checkNotNull(map);
        map.put(key, value);
        return this;
    }

    private final TUpdate initHttpRequest() {
        if (this.mApplication == null) {
            return this;
        }
        try {
            Boolean bl;
            HttpRequestor httpRequestor = HttpRequestor.Companion.getInstance();
            if (httpRequestor != null) {
                bl = BuildConfig.IS_TEST_MODE;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"IS_TEST_MODE");
                httpRequestor.setIfTestWorkMode(bl);
            }
            HttpRequestor httpRequestor2 = HttpRequestor.Companion.getInstance();
            if (httpRequestor2 != null) {
                Application application = this.mApplication;
                Intrinsics.checkNotNull((Object)application);
                bl = application.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"mApplication!!.resources");
                httpRequestor2.setLanguage(this.getLanguage((Resources)bl));
            }
            Boolean bl2 = BuildConfig.IS_TEST_MODE;
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"IS_TEST_MODE");
            LogUtil.INSTANCE.setLoggable1(bl2);
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e(e);
        }
        return this;
    }

    private final String getLanguage(Resources resources) {
        String string;
        try {
            Locale locale;
            Locale locale2 = locale = Build.VERSION.SDK_INT >= 24 ? resources.getConfiguration().getLocales().get(0) : resources.getConfiguration().locale;
            Intrinsics.checkNotNull((Object)locale2);
            string = locale2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            val locale\u2026cale!!.language\n        }");
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e(e);
            string = "";
        }
        return string;
    }

    @JvmOverloads
    public final void init(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        TUpdate.init$default(this, application, false, 2, null);
    }

    public /* synthetic */ TUpdate(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/cloud/tupdate/TUpdate$Companion;", "", "()V", "get", "Lcom/cloud/tupdate/TUpdate;", "getGet", "()Lcom/cloud/tupdate/TUpdate;", "get$delegate", "Lkotlin/Lazy;", "getContext", "Landroid/content/Context;", "newBuild", "Lcom/cloud/tupdate/UpdateManager$Builder;", "context", "tupdate_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TUpdate getGet() {
            Lazy lazy = get$delegate;
            return (TUpdate)lazy.getValue();
        }

        @NotNull
        public final Context getContext() {
            return (Context)this.getGet().getApplication();
        }

        @NotNull
        public final UpdateManager.Builder newBuild(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new UpdateManager.Builder(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

