/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate;

import android.content.Context;
import android.text.TextUtils;
import com.cloud.tupdate.TUpdateInner;
import com.cloud.tupdate.bean.DownloadEntity;
import com.cloud.tupdate.bean.UpdateEntity;
import com.cloud.tupdate.interfaces.IScoreListener;
import com.cloud.tupdate.interfaces.IUpdateChecker;
import com.cloud.tupdate.interfaces.IUpdateListener;
import com.cloud.tupdate.interfaces.IUpdateManager;
import com.cloud.tupdate.interfaces.IUpdateParser;
import com.cloud.tupdate.interfaces.IUpdatePrompter;
import com.cloud.tupdate.net.network.HttpRequestor;
import com.cloud.tupdate.utils.UpdateUtils;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001)B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00142\u0006\u0010#\u001a\u00020\u0010H\u0016J$\u0010$\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\b\u0010(\u001a\u00020\u0019H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/cloud/tupdate/UpdateManager;", "Lcom/cloud/tupdate/interfaces/IUpdateManager;", "builder", "Lcom/cloud/tupdate/UpdateManager$Builder;", "(Lcom/cloud/tupdate/UpdateManager$Builder;)V", "mContext", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "mIUpdateChecker", "Lcom/cloud/tupdate/interfaces/IUpdateChecker;", "mIUpdateParser", "Lcom/cloud/tupdate/interfaces/IUpdateParser;", "mIUpdatePrompter", "Lcom/cloud/tupdate/interfaces/IUpdatePrompter;", "mParams", "", "", "mScoreListener", "Lcom/cloud/tupdate/interfaces/IScoreListener;", "mUpdateEntity", "Lcom/cloud/tupdate/bean/UpdateEntity;", "mUpdateListener", "Lcom/cloud/tupdate/interfaces/IUpdateListener;", "mUpdateUrl", "checkVersion", "", "doUpdate", "findNewVersion", "updateEntity", "updateManager", "getContext", "getScoreListener", "getUpdateListener", "getUrl", "parseJson", "json", "showInstallDialog", "downloadEntity", "Lcom/cloud/tupdate/bean/DownloadEntity;", "showScoreDialog", "update", "Builder", "tupdate_release"})
public final class UpdateManager
implements IUpdateManager {
    @Nullable
    private UpdateEntity mUpdateEntity;
    @Nullable
    private final WeakReference<Context> mContext;
    @Nullable
    private final String mUpdateUrl;
    @Nullable
    private final Map<String, String> mParams;
    @Nullable
    private IUpdateChecker mIUpdateChecker;
    @Nullable
    private IUpdateParser mIUpdateParser;
    @Nullable
    private IUpdatePrompter mIUpdatePrompter;
    @Nullable
    private IUpdateListener mUpdateListener;
    @Nullable
    private IScoreListener mScoreListener;

    private UpdateManager(Builder builder) {
        this.mContext = new WeakReference<Context>(builder.getContext());
        this.mUpdateUrl = builder.getUpdateUrl();
        this.mParams = builder.getParams();
        this.mIUpdateChecker = builder.getUpdateChecker();
        this.mIUpdateParser = builder.getUpdateParser();
        this.mIUpdatePrompter = builder.getUpdatePrompter();
        this.mUpdateListener = builder.getUpdateListener();
        this.mScoreListener = builder.getScoreListener();
    }

    @Override
    @Nullable
    public Context getContext() {
        WeakReference<Context> weakReference = this.mContext;
        return weakReference == null ? null : (Context)weakReference.get();
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.mUpdateUrl;
    }

    @Override
    public void update() {
        this.doUpdate();
    }

    private final void doUpdate() {
        if (UpdateUtils.INSTANCE.checkNetwork()) {
            this.checkVersion();
        }
    }

    @Override
    public void checkVersion() {
        if (TextUtils.isEmpty((CharSequence)this.mUpdateUrl)) {
            throw new NullPointerException("[UpdateManager] : mUpdateUrl \u4e0d\u80fd\u4e3a\u7a7a");
        }
        IUpdateChecker iUpdateChecker = this.mIUpdateChecker;
        Intrinsics.checkNotNull((Object)iUpdateChecker);
        String string = this.mUpdateUrl;
        Intrinsics.checkNotNull((Object)string);
        iUpdateChecker.checkVersion(string, this.mParams, this);
    }

    @Override
    @Nullable
    public UpdateEntity parseJson(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (this.mIUpdateParser == null) {
            return null;
        }
        IUpdateParser iUpdateParser = this.mIUpdateParser;
        Intrinsics.checkNotNull((Object)iUpdateParser);
        this.mUpdateEntity = iUpdateParser.parseJson(json);
        return this.mUpdateEntity;
    }

    @Override
    public void findNewVersion(@NotNull UpdateEntity updateEntity, @NotNull IUpdateManager updateManager) {
        Intrinsics.checkNotNullParameter((Object)updateEntity, (String)"updateEntity");
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        IUpdatePrompter iUpdatePrompter = this.mIUpdatePrompter;
        if (iUpdatePrompter != null) {
            iUpdatePrompter.showUpdatePrompt(updateEntity, updateManager);
        }
    }

    @Override
    public void showScoreDialog(@NotNull UpdateEntity updateEntity, @NotNull IUpdateManager updateManager) {
        Intrinsics.checkNotNullParameter((Object)updateEntity, (String)"updateEntity");
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        IUpdatePrompter iUpdatePrompter = this.mIUpdatePrompter;
        if (iUpdatePrompter != null) {
            iUpdatePrompter.showScorePrompt(updateEntity, updateManager);
        }
    }

    @Override
    public void showInstallDialog(@Nullable UpdateEntity updateEntity, @Nullable DownloadEntity downloadEntity, @NotNull IUpdateManager updateManager) {
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        IUpdatePrompter iUpdatePrompter = this.mIUpdatePrompter;
        if (iUpdatePrompter != null) {
            iUpdatePrompter.showInstallDialog(updateEntity, downloadEntity, updateManager);
        }
    }

    @Override
    @Nullable
    public IUpdateListener getUpdateListener() {
        return this.mUpdateListener;
    }

    @Override
    @Nullable
    public IScoreListener getScoreListener() {
        return this.mScoreListener;
    }

    public /* synthetic */ UpdateManager(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010>\u001a\u00020?H\u0002J\u001e\u0010@\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010;\u001a\u00020\t2\u0006\u00105\u001a\u000206J\u0016\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0006\u0010D\u001a\u00020EJ\u000e\u00102\u001a\u00020\u00002\u0006\u00102\u001a\u00020\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u000b\"\u0004\b4\u0010\rR\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010;\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u000b\"\u0004\b=\u0010\r\u00a8\u0006F"}, d2={"Lcom/cloud/tupdate/UpdateManager$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "setContext", "packageName", "", "getPackageName", "()Ljava/lang/String;", "setPackageName", "(Ljava/lang/String;)V", "params", "", "getParams", "()Ljava/util/Map;", "setParams", "(Ljava/util/Map;)V", "scoreListener", "Lcom/cloud/tupdate/interfaces/IScoreListener;", "getScoreListener", "()Lcom/cloud/tupdate/interfaces/IScoreListener;", "setScoreListener", "(Lcom/cloud/tupdate/interfaces/IScoreListener;)V", "updateChecker", "Lcom/cloud/tupdate/interfaces/IUpdateChecker;", "getUpdateChecker", "()Lcom/cloud/tupdate/interfaces/IUpdateChecker;", "setUpdateChecker", "(Lcom/cloud/tupdate/interfaces/IUpdateChecker;)V", "updateListener", "Lcom/cloud/tupdate/interfaces/IUpdateListener;", "getUpdateListener", "()Lcom/cloud/tupdate/interfaces/IUpdateListener;", "setUpdateListener", "(Lcom/cloud/tupdate/interfaces/IUpdateListener;)V", "updateParser", "Lcom/cloud/tupdate/interfaces/IUpdateParser;", "getUpdateParser", "()Lcom/cloud/tupdate/interfaces/IUpdateParser;", "setUpdateParser", "(Lcom/cloud/tupdate/interfaces/IUpdateParser;)V", "updatePrompter", "Lcom/cloud/tupdate/interfaces/IUpdatePrompter;", "getUpdatePrompter", "()Lcom/cloud/tupdate/interfaces/IUpdatePrompter;", "setUpdatePrompter", "(Lcom/cloud/tupdate/interfaces/IUpdatePrompter;)V", "updateUrl", "getUpdateUrl", "setUpdateUrl", "versionCode", "", "getVersionCode", "()I", "setVersionCode", "(I)V", "versionName", "getVersionName", "setVersionName", "build", "Lcom/cloud/tupdate/UpdateManager;", "headers", "param", "key", "value", "update", "", "tupdate_release"})
    public static final class Builder {
        @NotNull
        private Context context;
        @Nullable
        private String updateUrl;
        @Nullable
        private Map<String, String> params;
        @NotNull
        private IUpdateParser updateParser;
        @NotNull
        private IUpdateChecker updateChecker;
        @NotNull
        private IUpdatePrompter updatePrompter;
        @Nullable
        private String packageName;
        @Nullable
        private String versionName;
        private int versionCode;
        @Nullable
        private IUpdateListener updateListener;
        @Nullable
        private IScoreListener scoreListener;

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            if (TUpdateInner.INSTANCE.getParams() != null) {
                if (this.params == null) {
                    this.params = new LinkedHashMap();
                }
                Map<String, String> map = this.params;
                Intrinsics.checkNotNull(map);
                Map<String, String> map2 = TUpdateInner.INSTANCE.getParams();
                Intrinsics.checkNotNull(map2);
                map.putAll(map2);
            }
            this.updateChecker = TUpdateInner.INSTANCE.getIUpdateChecker();
            this.updateParser = TUpdateInner.INSTANCE.getIUpdateParser();
            this.updatePrompter = TUpdateInner.INSTANCE.getIUpdatePrompter();
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        public final void setContext(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
            this.context = context;
        }

        @Nullable
        public final String getUpdateUrl() {
            return this.updateUrl;
        }

        public final void setUpdateUrl(@Nullable String string) {
            this.updateUrl = string;
        }

        @Nullable
        public final Map<String, String> getParams() {
            return this.params;
        }

        public final void setParams(@Nullable Map<String, String> map) {
            this.params = map;
        }

        @NotNull
        public final IUpdateParser getUpdateParser() {
            return this.updateParser;
        }

        public final void setUpdateParser(@NotNull IUpdateParser iUpdateParser) {
            Intrinsics.checkNotNullParameter((Object)iUpdateParser, (String)"<set-?>");
            this.updateParser = iUpdateParser;
        }

        @NotNull
        public final IUpdateChecker getUpdateChecker() {
            return this.updateChecker;
        }

        public final void setUpdateChecker(@NotNull IUpdateChecker iUpdateChecker) {
            Intrinsics.checkNotNullParameter((Object)iUpdateChecker, (String)"<set-?>");
            this.updateChecker = iUpdateChecker;
        }

        @NotNull
        public final IUpdatePrompter getUpdatePrompter() {
            return this.updatePrompter;
        }

        public final void setUpdatePrompter(@NotNull IUpdatePrompter iUpdatePrompter) {
            Intrinsics.checkNotNullParameter((Object)iUpdatePrompter, (String)"<set-?>");
            this.updatePrompter = iUpdatePrompter;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(@Nullable String string) {
            this.packageName = string;
        }

        @Nullable
        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(@Nullable String string) {
            this.versionName = string;
        }

        public final int getVersionCode() {
            return this.versionCode;
        }

        public final void setVersionCode(int n) {
            this.versionCode = n;
        }

        @Nullable
        public final IUpdateListener getUpdateListener() {
            return this.updateListener;
        }

        public final void setUpdateListener(@Nullable IUpdateListener iUpdateListener) {
            this.updateListener = iUpdateListener;
        }

        @Nullable
        public final IScoreListener getScoreListener() {
            return this.scoreListener;
        }

        public final void setScoreListener(@Nullable IScoreListener iScoreListener) {
            this.scoreListener = iScoreListener;
        }

        @NotNull
        public final Builder updateUrl(@NotNull String updateUrl) {
            Intrinsics.checkNotNullParameter((Object)updateUrl, (String)"updateUrl");
            this.updateUrl = updateUrl;
            return this;
        }

        @NotNull
        public final Builder param(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (this.params == null) {
                this.params = new LinkedHashMap();
            }
            Map<String, String> map = this.params;
            Intrinsics.checkNotNull(map);
            map.put(key, value);
            return this;
        }

        @NotNull
        public final Builder headers(@NotNull String packageName, @NotNull String versionName, int versionCode) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            this.packageName = packageName;
            this.versionName = versionName;
            this.versionCode = versionCode;
            HttpRequestor httpRequestor = HttpRequestor.Companion.getInstance();
            if (httpRequestor != null) {
                httpRequestor.setAppInfo(packageName, versionName, versionCode);
            }
            return this;
        }

        @NotNull
        public final Builder setUpdateListener(@NotNull IUpdateListener updateListener) {
            Intrinsics.checkNotNullParameter((Object)updateListener, (String)"updateListener");
            this.updateListener = updateListener;
            return this;
        }

        @NotNull
        public final Builder setScoreListener(@NotNull IScoreListener scoreListener) {
            Intrinsics.checkNotNullParameter((Object)scoreListener, (String)"scoreListener");
            this.scoreListener = scoreListener;
            return this;
        }

        private final UpdateManager build() {
            UpdateUtils.INSTANCE.requireNonNull(this.context, "[UpdateManager.Builder] : context == null");
            return new UpdateManager(this, null);
        }

        public final void update() {
            CharSequence charSequence = this.updateUrl;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                this.updateUrl = "https://app-manage-api.shalltry.com/common/app-management/v1/consumer-not-login/versioncontent/query/get";
            }
            if ((charSequence = (CharSequence)this.packageName) == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)this.versionName) == null || StringsKt.isBlank((CharSequence)charSequence) || this.versionCode == 0) {
                HttpRequestor httpRequestor = HttpRequestor.Companion.getInstance();
                if (httpRequestor != null) {
                    String string = this.context.getPackageName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
                    httpRequestor.setAppInfo(string, UpdateUtils.INSTANCE.getVersionName(this.context), UpdateUtils.INSTANCE.getVersionCode(this.context));
                }
            }
            this.build().update();
        }
    }
}

