/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatDialog;
import com.cloud.tupdate.R;

public class TranssionDialog
extends AppCompatDialog {
    private final SparseArray<View> views;
    private OnClickListener onClickListener;
    private OnLongClickListener onLongClickListener;

    private TranssionDialog(@NonNull Context context, @LayoutRes int contentId, @StyleRes int themeResId) {
        super(context, themeResId);
        this.setContentView(contentId);
        this.views = new SparseArray();
    }

    public TranssionDialog setText(@IdRes int viewId, CharSequence value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(value);
        return this;
    }

    public TranssionDialog setText(@IdRes int viewId, @StringRes int strId) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(strId);
        return this;
    }

    public TranssionDialog setImageResource(@IdRes int viewId, @DrawableRes int imageResId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    public TranssionDialog setBackgroundColor(@IdRes int viewId, @ColorInt int color) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    public TranssionDialog setBackgroundRes(@IdRes int viewId, @DrawableRes int backgroundRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public TranssionDialog setTextColor(@IdRes int viewId, @ColorInt int textColor) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public TranssionDialog setEnable(@IdRes int viewId, boolean enable) {
        Object view = this.getView(viewId);
        view.setEnabled(enable);
        return this;
    }

    public TranssionDialog setImageDrawable(@IdRes int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    public TranssionDialog setImageBitmap(@IdRes int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public TranssionDialog setAlpha(@IdRes int viewId, @FloatRange(from=0.0, to=1.0) float value) {
        Object view = this.getView(viewId);
        view.setAlpha(value);
        return this;
    }

    public TranssionDialog setGone(@IdRes int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public TranssionDialog setVisible(@IdRes int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 4);
        return this;
    }

    public TranssionDialog linkify(@IdRes int viewId) {
        TextView view = (TextView)this.getView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public TranssionDialog setTypeface(@IdRes int viewId, Typeface typeface) {
        TextView view = (TextView)this.getView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    public TranssionDialog setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public TranssionDialog setProgress(@IdRes int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setProgress(progress);
        return this;
    }

    public TranssionDialog setProgress(@IdRes int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public TranssionDialog setMax(@IdRes int viewId, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        return this;
    }

    public TranssionDialog setRating(@IdRes int viewId, float rating) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setRating(rating);
        return this;
    }

    public TranssionDialog setRating(@IdRes int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public TranssionDialog setAdapter(@IdRes int viewId, Adapter adapter) {
        AdapterView view = (AdapterView)this.getView(viewId);
        view.setAdapter(adapter);
        return this;
    }

    public TranssionDialog setChecked(@IdRes int viewId, boolean checked) {
        Object view = this.getView(viewId);
        if (view instanceof Checkable) {
            ((Checkable)view).setChecked(checked);
        }
        return this;
    }

    public TranssionDialog setTag(@IdRes int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    public TranssionDialog setOnItemSelectedClickListener(@IdRes int viewId, AdapterView.OnItemSelectedListener listener) {
        AdapterView view = (AdapterView)this.getView(viewId);
        view.setOnItemSelectedListener(listener);
        return this;
    }

    public TranssionDialog setOnCheckedChangeListener(@IdRes int viewId, CompoundButton.OnCheckedChangeListener listener) {
        CompoundButton view = (CompoundButton)this.getView(viewId);
        view.setOnCheckedChangeListener(listener);
        return this;
    }

    public TranssionDialog setTag(@IdRes int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public TranssionDialog addOnClickListener(int ... viewId) {
        for (int id : viewId) {
            Object view = this.getView(id);
            if (view == null) continue;
            if (!view.isClickable()) {
                view.setClickable(true);
            }
            view.setOnClickListener(v -> {
                if (this.onClickListener != null) {
                    this.onClickListener.onClick(this, v);
                }
            });
        }
        return this;
    }

    public TranssionDialog addOnLongClickListener(int ... viewId) {
        for (int id : viewId) {
            Object view = this.getView(id);
            if (view == null) continue;
            if (!view.isClickable()) {
                view.setLongClickable(true);
            }
            view.setOnLongClickListener(v -> {
                if (this.onLongClickListener != null) {
                    return this.onLongClickListener.onLongClick(this, v);
                }
                return false;
            });
        }
        return this;
    }

    public <T extends View> T getView(@IdRes int viewId) {
        View view = (View)this.views.get(viewId);
        if (null == view) {
            view = this.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public static Builder newBuilder(Context context, @StyleRes int themeId) {
        return new Builder(context, themeId);
    }

    public TranssionDialog showAndGet() {
        super.show();
        return this;
    }

    public TranssionDialog setOnClickListener(OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
        return this;
    }

    public TranssionDialog setOnLongClickListener(OnLongClickListener onLongClickListener) {
        this.onLongClickListener = onLongClickListener;
        return this;
    }

    public static interface OnLongClickListener {
        public boolean onLongClick(TranssionDialog var1, View var2);
    }

    public static interface OnClickListener {
        public void onClick(TranssionDialog var1, View var2);
    }

    public static class Builder {
        private final Context context;
        private int themeId;
        private int contentId;
        private int animationId;
        private boolean cancelable = true;
        private boolean cancelOnTouchOutside;
        private int gravity = 17;
        private int width = -2;
        private int height = -2;
        private DialogInterface.OnCancelListener onCancelListener;
        private DialogInterface.OnDismissListener onDismissListener;
        private DialogInterface.OnKeyListener onKeyListener;
        private DialogInterface.OnShowListener onShowListener;

        public Builder(Context context) {
            this(context, R.style.update_style_dialog);
        }

        public Builder(Context context, @StyleRes int themeId) {
            this.context = context;
            this.themeId = themeId;
        }

        public Builder themeId(@StyleRes int themeId) {
            this.themeId = themeId;
            return this;
        }

        public Builder contentId(@LayoutRes int contentId) {
            this.contentId = contentId;
            return this;
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder fullWidth() {
            this.width = -1;
            return this;
        }

        public Builder fullHeight() {
            this.height = -1;
            return this;
        }

        public Builder fullScreen() {
            this.width = -1;
            this.height = -1;
            return this;
        }

        public Builder screenWidthPercent(@FloatRange(from=0.0, to=1.0) float percent) {
            this.width = (int)((float)this.context.getResources().getDisplayMetrics().widthPixels * percent);
            return this;
        }

        public Builder screenHeightPercent(@FloatRange(from=0.0, to=1.0) float percent) {
            this.height = (int)((float)this.context.getResources().getDisplayMetrics().heightPixels * percent);
            return this;
        }

        public Builder setWidthAndHeight(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder animationId(@StyleRes int animtionId) {
            this.animationId = animtionId;
            return this;
        }

        public Builder cancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder cancelOnTouchOutside(boolean cancelable) {
            this.cancelOnTouchOutside = cancelable;
            return this;
        }

        public Builder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
            this.onCancelListener = onCancelListener;
            return this;
        }

        public Builder setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
            this.onDismissListener = onDismissListener;
            return this;
        }

        public Builder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
            this.onKeyListener = onKeyListener;
            return this;
        }

        public Builder setOnShowListener(DialogInterface.OnShowListener onShowListener) {
            this.onShowListener = onShowListener;
            return this;
        }

        public TranssionDialog build() {
            if (this.contentId == 0) {
                throw new IllegalArgumentException("please set contentId");
            }
            TranssionDialog dialog = new TranssionDialog(this.context, this.contentId, this.themeId);
            dialog.setCancelable(this.cancelable);
            if (this.cancelable) {
                dialog.setCanceledOnTouchOutside(this.cancelOnTouchOutside);
            }
            dialog.setOnCancelListener(this.onCancelListener);
            dialog.setOnDismissListener(this.onDismissListener);
            dialog.setOnKeyListener(this.onKeyListener);
            dialog.setOnShowListener(this.onShowListener);
            Window window = dialog.getWindow();
            window.setWindowAnimations(this.animationId);
            window.setGravity(this.gravity);
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.width = this.width;
            lp.height = this.height;
            window.setAttributes(lp);
            return dialog;
        }
    }
}

