/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.net.sign;

import android.os.Build;
import android.text.TextUtils;
import com.cloud.tupdate.net.sign.BasicSigner;
import com.cloud.tupdate.net.sign.Crypto;
import com.cloud.tupdate.net.sign.GatewayResponse;
import com.cloud.tupdate.net.sign.SharedPreferencesHelper;
import com.cloud.tupdate.net.sign.SignAlgorithm;
import com.cloud.tupdate.net.sign.Signer;
import com.cloud.tupdate.net.sign.TimeBean;
import com.cloud.tupdate.net.utils.LogUtil;
import com.google.gson.Gson;
import com.transsion.core.utils.EncoderUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class HttpSigner {
    private final Signer signer;
    public static boolean isTest = false;
    private static final String TEST_SECRET = "Xqn2nnO41/L92o1iuXhSLHTbXvY4Z5ZZ62m8mSLA";
    private static final String RELEASE_SECRET = "76iRl07s0xSN9jqmEWAt79EBJZulIQIsV64FZr2O";

    public HttpSigner(Signer signer) {
        this.signer = signer;
    }

    public static void setTest(boolean flag) {
        isTest = flag;
    }

    public static String getSecret() {
        return isTest ? TEST_SECRET : RELEASE_SECRET;
    }

    public static String doSign(String method, String accept, String contentType, String url, String body) {
        long timenow = System.currentTimeMillis();
        long offset = SharedPreferencesHelper.getInstance().getLong("time_offset");
        long timeStamp = System.currentTimeMillis() + offset;
        String secret = HttpSigner.getSecret();
        BasicSigner basicSigner = new BasicSigner(secret);
        HttpSigner httpSigner = new HttpSigner(basicSigner);
        String sign = httpSigner.sign(method, accept, contentType, url, body, timeStamp);
        LogUtil.INSTANCE.d("x-tr-signature: " + timeStamp + "|2|" + sign);
        LogUtil.INSTANCE.d("doSign latency: " + (System.currentTimeMillis() - timenow));
        return timeStamp + "|2|" + sign;
    }

    public String sign(String method, String accept, String contentType, String url, String body, long timeStamp) {
        String content = this.generateContent(method, accept, contentType, url, body, timeStamp);
        return this.signer.sign(SignAlgorithm.HmacMD5, content);
    }

    private String generateContent(String method, String accept, String contentType, String url, String body, long timeStamp) {
        StringBuilder stringBuilder = new StringBuilder();
        String md5 = "";
        long contentLength = 0L;
        if (!TextUtils.isEmpty((CharSequence)body)) {
            LogUtil.INSTANCE.d("request body is not null");
            try {
                contentLength = body.getBytes("UTF-8").length;
                long timenow = System.currentTimeMillis();
                md5 = body.length() > 102400 ? EncoderUtil.EncoderByAlgorithm((String)body.substring(0, 102400), (String)"MD5") : EncoderUtil.EncoderByAlgorithm((String)body, (String)"MD5");
                LogUtil.INSTANCE.d("md5 duration" + (System.currentTimeMillis() - timenow));
            }
            catch (Exception e) {
                LogUtil.INSTANCE.d("generateContent exception" + e.toString());
            }
        } else {
            LogUtil.INSTANCE.d("request body is null");
        }
        stringBuilder.append(method.toUpperCase()).append("\n").append(accept == null ? "" : accept).append("\n").append(contentType == null ? "" : contentType).append("\n").append(contentLength == 0L ? "" : Long.valueOf(contentLength)).append("\n").append(timeStamp).append("\n").append(TextUtils.isEmpty((CharSequence)md5) ? "" : md5).append("\n").append(this.buildPathAndParameters(url));
        LogUtil.INSTANCE.d(stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String formatUrlMap(Map<String, String> paraMap) {
        String buff;
        try {
            ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(paraMap.entrySet());
            Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if ("".equals(entry.getKey())) continue;
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                buf.append(key).append("=").append(val);
                buf.append("&");
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            buff = buf.toString();
        }
        catch (Exception e) {
            return null;
        }
        return buff;
    }

    private String splitQuery(String queryString) {
        String[] pairs;
        HashMap<String, String> queryPairs = new HashMap<String, String>();
        for (String pair : pairs = queryString.split("&")) {
            int idx = pair.indexOf("=");
            try {
                queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.formatUrlMap(queryPairs);
    }

    private String buildPathAndParameters(String url) {
        String formatedUrl;
        URI uri;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return "";
        }
        stringBuilder.append(uri.getPath());
        if (!TextUtils.isEmpty((CharSequence)uri.getQuery()) && !TextUtils.isEmpty((CharSequence)(formatedUrl = this.splitQuery(uri.getQuery())))) {
            LogUtil.INSTANCE.d("formatedUrl" + formatedUrl);
            stringBuilder.append("?").append(formatedUrl);
        }
        return stringBuilder.toString();
    }

    public static boolean needRetryForTimeIssue(int code, String response) {
        if (code != 500 && TextUtils.isEmpty((CharSequence)response)) {
            return false;
        }
        Gson gson = new Gson();
        try {
            LogUtil.INSTANCE.d("response" + response);
            GatewayResponse gatewayResponse = (GatewayResponse)gson.fromJson(response, GatewayResponse.class);
            String errorMsg = "GW.4410";
            if (errorMsg.equals(gatewayResponse.error_code)) {
                LogUtil.INSTANCE.d("verify sign failed, retrying update time");
                String msg = gatewayResponse.error_msg;
                if (Build.VERSION.SDK_INT >= 19) {
                    TimeBean time = (TimeBean)gson.fromJson(Crypto.Decrypt(msg), TimeBean.class);
                    if (time.time > 0L) {
                        SharedPreferencesHelper.getInstance().putLong("time_offset", time.time - System.currentTimeMillis());
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e(e);
        }
        return false;
    }
}

