/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.net.utils;

import com.cloud.tupdate.net.utils.LogUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\b\u0010\t\u001a\u00020\u0006H\u0002J\u0006\u0010\n\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/cloud/tupdate/net/utils/ThreadPoolUtil;", "", "()V", "mExecutorService", "Ljava/util/concurrent/ExecutorService;", "executeRunable", "", "runnable", "Ljava/lang/Runnable;", "initThreadPool", "shutdownExecutor", "Companion", "ThreadPoolUtilsHolder", "tupdate_release"})
public final class ThreadPoolUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ExecutorService mExecutorService;

    private ThreadPoolUtil() {
        this.initThreadPool();
    }

    private final void initThreadPool() {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newCachedThreadPool();
        }
    }

    public final void executeRunable(@Nullable Runnable runnable) {
        try {
            ExecutorService executorService = this.mExecutorService;
            Boolean bl = executorService == null ? null : Boolean.valueOf(executorService.isShutdown());
            Intrinsics.checkNotNull((Object)bl);
            if (!bl.booleanValue()) {
                ExecutorService executorService2 = this.mExecutorService;
                if (executorService2 != null) {
                    executorService2.execute(runnable);
                }
            }
        }
        catch (RejectedExecutionException e) {
            LogUtil.INSTANCE.e(e);
        }
    }

    public final void shutdownExecutor() {
        ExecutorService executorService = this.mExecutorService;
        Boolean bl = executorService == null ? null : Boolean.valueOf(executorService.isShutdown());
        Intrinsics.checkNotNull((Object)bl);
        if (!bl.booleanValue()) {
            ExecutorService executorService2 = this.mExecutorService;
            Intrinsics.checkNotNull((Object)executorService2);
            executorService2.shutdown();
            this.mExecutorService = null;
        }
    }

    public /* synthetic */ ThreadPoolUtil(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cloud/tupdate/net/utils/ThreadPoolUtil$ThreadPoolUtilsHolder;", "", "()V", "instance", "Lcom/cloud/tupdate/net/utils/ThreadPoolUtil;", "getInstance", "()Lcom/cloud/tupdate/net/utils/ThreadPoolUtil;", "tupdate_release"})
    private static final class ThreadPoolUtilsHolder {
        @NotNull
        public static final ThreadPoolUtilsHolder INSTANCE = new ThreadPoolUtilsHolder();
        @Nullable
        private static final ThreadPoolUtil instance = new ThreadPoolUtil(null);

        private ThreadPoolUtilsHolder() {
        }

        @Nullable
        public final ThreadPoolUtil getInstance() {
            return instance;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/cloud/tupdate/net/utils/ThreadPoolUtil$Companion;", "", "()V", "getInstance", "Lcom/cloud/tupdate/net/utils/ThreadPoolUtil;", "tupdate_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ThreadPoolUtil getInstance() {
            return ThreadPoolUtilsHolder.INSTANCE.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

