/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import com.cloud.tupdate.net.utils.LogUtil;
import com.cloud.tupdate.utils.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/cloud/tupdate/utils/ApkInstallUtils;", "", "()V", "Companion", "tupdate_release"})
public final class ApkInstallUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int REQUEST_CODE_INSTALL_APP = 999;

    private ApkInstallUtils() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u001a\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/cloud/tupdate/utils/ApkInstallUtils$Companion;", "", "()V", "REQUEST_CODE_INSTALL_APP", "", "getInstallAppIntent", "Landroid/content/Intent;", "appFile", "Ljava/io/File;", "install", "", "context", "Landroid/content/Context;", "apkFile", "installNormal", "filePath", "", "tupdate_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean install(@NotNull Context context, @NotNull File apkFile) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
            try {
                String string = apkFile.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apkFile.canonicalPath");
                bl = this.installNormal(context, string);
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        private final boolean installNormal(Context context, String filePath) {
            File file = FileUtils.Companion.getFileByPath(filePath);
            return FileUtils.Companion.isFileExists(file) && this.installNormal(context, file);
        }

        private final boolean installNormal(Context context, File appFile) {
            try {
                Intent intent = this.getInstallAppIntent(appFile);
                PackageManager packageManager = context.getPackageManager();
                Intent intent2 = intent;
                Intrinsics.checkNotNull((Object)intent2);
                if (packageManager.queryIntentActivities(intent2, 0).size() > 0) {
                    if (context instanceof Activity) {
                        ((Activity)context).startActivityForResult(intent, 999);
                    } else {
                        context.startActivity(intent);
                    }
                    return true;
                }
            }
            catch (Exception e) {
                LogUtil.INSTANCE.i("Apk installation failed using the intent of the system!");
            }
            return false;
        }

        private final Intent getInstallAppIntent(File appFile) {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setFlags(0x10000000);
                if (Build.VERSION.SDK_INT >= 24) {
                    intent.setFlags(1);
                    Uri fileUri = FileUtils.Companion.getUriByFile(appFile);
                    intent.setDataAndType(fileUri, "application/vnd.android.package-archive");
                } else {
                    intent.setDataAndType(Uri.fromFile((File)appFile), "application/vnd.android.package-archive");
                }
                return intent;
            }
            catch (Exception e) {
                LogUtil.INSTANCE.i("Failed to get intent for installation\uff01");
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

