/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import com.cloud.tupdate.bean.UpdateContent;
import com.cloud.tupdate.interfaces.IUpdateManager;
import com.cloud.tupdate.net.utils.LogUtil;
import com.cloud.tupdate.utils.AthenaUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\r\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0011\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002J&\u0010\u0013\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/cloud/tupdate/utils/CommonUtils;", "", "()V", "dismissDialog", "", "context", "Landroid/content/Context;", "dialog", "Landroid/app/Dialog;", "updateContent", "Lcom/cloud/tupdate/bean/UpdateContent;", "getAppName", "", "handleUpdateUrl", "updateManager", "Lcom/cloud/tupdate/interfaces/IUpdateManager;", "jumpMarket", "openBrowser", "url", "openSchemeUrl", "tupdate_release"})
public final class CommonUtils {
    @NotNull
    public static final CommonUtils INSTANCE = new CommonUtils();

    private CommonUtils() {
    }

    public final void jumpMarket(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Uri uri = Uri.parse((String)("palmplay://thirdlauncher.com/?entryType=AppDetail&name=" + this.getAppName(context) + "&_source=BussSDK&detailType=SOFT&utm_source=pushsdk&_mediatype=Install&packageName=" + context.getPackageName()));
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            AthenaUtils.INSTANCE.trackOtherEvent("open_palmstore_home", new Bundle());
            this.openBrowser(context, "http://www.palmplaystore.com/");
        }
    }

    public final void handleUpdateUrl(@Nullable UpdateContent updateContent, @NotNull IUpdateManager updateManager, @Nullable Dialog dialog) {
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        UpdateContent updateContent2 = updateContent;
        String updateUrl = updateContent2 == null ? null : updateContent2.getUpdateUrl();
        CharSequence charSequence = updateUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        Context context = updateManager.getContext();
        if (context == null) {
            return;
        }
        Context context2 = context;
        if (StringsKt.startsWith$default((String)updateUrl, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)updateUrl, (String)"https://", (boolean)false, (int)2, null)) {
            this.dismissDialog(context2, dialog, updateContent);
            this.openBrowser(context2, updateUrl);
        } else {
            this.openSchemeUrl(context2, updateContent, dialog);
        }
    }

    private final void openBrowser(Context context, String url) {
        if (context == null) {
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e(e);
        }
    }

    private final void openSchemeUrl(Context context, UpdateContent updateContent, Dialog dialog) {
        UpdateContent updateContent2 = updateContent;
        String url = updateContent2 == null ? null : updateContent2.getUpdateUrl();
        CharSequence charSequence = url;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || context == null) {
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            this.dismissDialog(context, dialog, updateContent);
            context.startActivity(intent);
        }
        catch (Exception e) {
            AthenaUtils.INSTANCE.trackOtherEvent("open_palmstore_home", new Bundle());
            this.openBrowser(context, "http://www.palmplaystore.com/");
        }
    }

    private final void dismissDialog(Context context, Dialog dialog, UpdateContent updateContent) {
        try {
            if (context instanceof Activity && !((Activity)context).isFinishing()) {
                if (Intrinsics.areEqual((Object)updateContent.getForce(), (Object)false)) {
                    Dialog dialog2 = dialog;
                    if (dialog2 != null) {
                        dialog2.dismiss();
                    }
                }
            } else {
                Dialog dialog3 = dialog;
                if (dialog3 != null) {
                    dialog3.dismiss();
                }
            }
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e(e);
        }
    }

    private final String getAppName(Context context) {
        String string;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            string = context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }
}

