/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import androidx.annotation.RequiresApi;
import androidx.core.content.FileProvider;
import com.cloud.tupdate.TUpdate;
import com.cloud.tupdate.net.utils.LogUtil;
import com.cloud.tupdate.utils.AthenaUtils;
import com.cloud.tupdate.utils.Md5Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/cloud/tupdate/utils/FileUtils;", "", "()V", "Companion", "tupdate_release"})
public final class FileUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MODE_READ_ONLY = "r";
    @NotNull
    private static final String EXT_STORAGE_PATH = com.cloud.tupdate.utils.FileUtils$Companion.access$getExtStoragePath(Companion);
    @NotNull
    private static final String EXT_STORAGE_DIR = Intrinsics.stringPlus((String)EXT_STORAGE_PATH, (Object)File.separator);
    @NotNull
    private static final String APP_EXT_STORAGE_PATH = Intrinsics.stringPlus((String)EXT_STORAGE_DIR, (Object)"Android");
    @NotNull
    private static final String EXT_DOWNLOADS_PATH = com.cloud.tupdate.utils.FileUtils$Companion.access$getExtDownloadsPath(Companion);
    @NotNull
    private static final String EXT_PICTURES_PATH = com.cloud.tupdate.utils.FileUtils$Companion.access$getExtPicturesPath(Companion);
    @NotNull
    private static final String EXT_DCIM_PATH = com.cloud.tupdate.utils.FileUtils$Companion.access$getExtDCIMPath(Companion);

    private FileUtils() {
    }

    @JvmStatic
    public static final void close(Closeable ... closeables) {
        Companion.close(closeables);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f0\u001e\"\u0004\u0018\u00010\u001fH\u0007\u00a2\u0006\u0002\u0010 J%\u0010!\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f0\u001e\"\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010'2\b\u0010)\u001a\u0004\u0018\u00010\u0004J\u0012\u0010*\u001a\u0004\u0018\u00010+2\b\u0010&\u001a\u0004\u0018\u00010'J\u001a\u0010,\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020'H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010#2\b\u0010&\u001a\u0004\u0018\u00010'J\u0014\u0010/\u001a\u0004\u0018\u00010#2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u00100\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010'J\u0012\u00100\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u00101\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u00102\u001a\u00020\u00192\b\u00103\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00010'J\u0012\u00104\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u00104\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0012\u00105\u001a\u00020\u00192\b\u00106\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006:"}, d2={"Lcom/cloud/tupdate/utils/FileUtils$Companion;", "", "()V", "APP_EXT_STORAGE_PATH", "", "EXT_DCIM_PATH", "EXT_DOWNLOADS_PATH", "EXT_PICTURES_PATH", "EXT_STORAGE_DIR", "EXT_STORAGE_PATH", "MODE_READ_ONLY", "contentResolver", "Landroid/content/ContentResolver;", "getContentResolver", "()Landroid/content/ContentResolver;", "extDCIMPath", "getExtDCIMPath", "()Ljava/lang/String;", "extDownloadsPath", "getExtDownloadsPath", "extPicturesPath", "getExtPicturesPath", "extStoragePath", "getExtStoragePath", "isScopedStorageMode", "", "()Z", "close", "", "closeables", "", "Ljava/io/Closeable;", "([Ljava/io/Closeable;)V", "closeIOQuietly", "getDownloadContentUri", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "getFileByPath", "filePath", "getFileInputStream", "Ljava/io/InputStream;", "getMediaContentUri", "mediaFile", "getUriByFile", "getUriForFile", "isFileExists", "isFileExistsApi29", "isFileValid", "originalMd5", "isPublicPath", "isSpace", "s", "openAssetFileDescriptor", "Landroid/content/res/AssetFileDescriptor;", "uri", "tupdate_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final File getFileByPath(@Nullable String filePath) {
            CharSequence charSequence = filePath;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return this.isSpace(filePath) ? null : new File(filePath);
        }

        public final boolean isFileExists(@Nullable File file) {
            if (file == null) {
                return false;
            }
            return file.exists() ? true : this.isFileExists(file.getAbsolutePath());
        }

        private final boolean isFileExists(String filePath) {
            File file = this.getFileByPath(filePath);
            if (file == null) {
                return false;
            }
            File file2 = file;
            return file2.exists() ? true : this.isFileExistsApi29(filePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean isFileExistsApi29(String filePath) {
            block6: {
                Closeable[] uri;
                AssetFileDescriptor afd;
                block5: {
                    if (Build.VERSION.SDK_INT < 29) break block6;
                    afd = null;
                    uri = Uri.parse((String)filePath);
                    afd = this.openAssetFileDescriptor((Uri)uri);
                    if (afd != null) break block5;
                    boolean bl = false;
                    Closeable[] closeableArray = new Closeable[]{(Closeable)afd};
                    this.closeIOQuietly(closeableArray);
                    return bl;
                }
                try {
                    Closeable[] closeableArray = new Closeable[]{(Closeable)afd};
                    this.closeIOQuietly(closeableArray);
                }
                catch (FileNotFoundException e) {
                    boolean bl;
                    try {
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        Closeable[] closeableArray = new Closeable[]{(Closeable)afd};
                        this.closeIOQuietly(closeableArray);
                        throw throwable;
                    }
                    Closeable[] closeableArray = new Closeable[]{(Closeable)afd};
                    this.closeIOQuietly(closeableArray);
                    return bl;
                }
                uri = new Closeable[]{(Closeable)afd};
                this.closeIOQuietly(uri);
                return true;
            }
            return false;
        }

        @Nullable
        public final InputStream getFileInputStream(@Nullable File file) {
            InputStream inputStream;
            try {
                InputStream inputStream2;
                if (this.isScopedStorageMode()) {
                    Uri uri = this.getUriByFile(file);
                    if (uri == null) {
                        return null;
                    }
                    Uri uri2 = uri;
                    inputStream2 = this.getContentResolver().openInputStream(uri2);
                } else {
                    inputStream2 = new FileInputStream(file);
                }
                inputStream = inputStream2;
            }
            catch (Exception e) {
                LogUtil.INSTANCE.e(e);
                inputStream = null;
            }
            return inputStream;
        }

        @Nullable
        public final Uri getUriByFile(@Nullable File file) {
            Uri uri;
            if (file == null) {
                return null;
            }
            if (this.isScopedStorageMode() && this.isPublicPath(file)) {
                String filePath = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
                uri = StringsKt.startsWith$default((String)filePath, (String)EXT_DOWNLOADS_PATH, (boolean)false, (int)2, null) ? this.getDownloadContentUri(TUpdate.Companion.getContext(), file) : (StringsKt.startsWith$default((String)filePath, (String)EXT_PICTURES_PATH, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)filePath, (String)EXT_DCIM_PATH, (boolean)false, (int)2, null) ? this.getMediaContentUri(TUpdate.Companion.getContext(), file) : this.getUriForFile(file));
            } else {
                uri = this.getUriForFile(file);
            }
            return uri;
        }

        private final Uri getUriForFile(File file) {
            Uri uri;
            if (file == null) {
                return null;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                String authority = Intrinsics.stringPlus((String)TUpdate.Companion.getContext().getPackageName(), (Object)".updateFileProvider");
                uri = FileProvider.getUriForFile((Context)TUpdate.Companion.getContext(), (String)authority, (File)file);
            } else {
                uri = Uri.fromFile((File)file);
            }
            return uri;
        }

        private final Uri getMediaContentUri(Context context, File mediaFile) {
            Uri uri;
            try {
                Uri uri2;
                String filePath = mediaFile.getAbsolutePath();
                Uri baseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                String[] stringArray = new String[]{"_id"};
                String[] stringArray2 = stringArray;
                stringArray = new String[]{filePath};
                Cursor cursor = context.getContentResolver().query(baseUri, stringArray2, "_data=? ", stringArray, null);
                if (cursor != null && cursor.moveToFirst()) {
                    int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
                    cursor.close();
                    uri2 = Uri.withAppendedPath((Uri)baseUri, (String)Intrinsics.stringPlus((String)"", (Object)id2));
                } else {
                    if (mediaFile.exists()) {
                        ContentValues values = new ContentValues();
                        values.put("_data", filePath);
                        return context.getContentResolver().insert(baseUri, values);
                    }
                    uri2 = null;
                }
                uri = uri2;
            }
            catch (Exception e) {
                e.printStackTrace();
                uri = null;
            }
            return uri;
        }

        private final boolean isScopedStorageMode() {
            return Build.VERSION.SDK_INT >= 29 && !Environment.isExternalStorageLegacy();
        }

        @RequiresApi(api=29)
        @Nullable
        public final Uri getDownloadContentUri(@NotNull Context context, @NotNull File file) {
            Uri uri;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try {
                Uri uri2;
                String filePath = file.getAbsolutePath();
                Uri uri3 = MediaStore.Downloads.EXTERNAL_CONTENT_URI;
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"EXTERNAL_CONTENT_URI");
                Uri baseUri = uri3;
                String[] stringArray = new String[]{"_id"};
                String[] stringArray2 = stringArray;
                stringArray = new String[]{filePath};
                Cursor cursor = context.getContentResolver().query(baseUri, stringArray2, "_data=? ", stringArray, null);
                if (cursor != null && cursor.moveToFirst()) {
                    int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
                    cursor.close();
                    uri2 = Uri.withAppendedPath((Uri)baseUri, (String)Intrinsics.stringPlus((String)"", (Object)id2));
                } else {
                    if (file.exists()) {
                        ContentValues values = new ContentValues();
                        values.put("_data", filePath);
                        return context.getContentResolver().insert(baseUri, values);
                    }
                    uri2 = null;
                }
                uri = uri2;
            }
            catch (Exception e) {
                e.printStackTrace();
                uri = null;
            }
            return uri;
        }

        private final boolean isPublicPath(File file) {
            if (file == null) {
                return false;
            }
            try {
                String string2 = file.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.canonicalPath");
                return this.isPublicPath(string2);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        private final boolean isPublicPath(String filePath) {
            return this.isSpace(filePath) ? false : StringsKt.startsWith$default((String)filePath, (String)EXT_STORAGE_PATH, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)filePath, (String)APP_EXT_STORAGE_PATH, (boolean)false, (int)2, null);
        }

        private final boolean isSpace(String s) {
            if (s == null) {
                return true;
            }
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private final void closeIOQuietly(Closeable ... closeables) {
            int n = 0;
            int n2 = closeables.length;
            while (n < n2) {
                Closeable closeable = closeables[n];
                ++n;
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Nullable
        public final AssetFileDescriptor openAssetFileDescriptor(@Nullable Uri uri) throws FileNotFoundException {
            ContentResolver contentResolver = this.getContentResolver();
            Uri uri2 = uri;
            Intrinsics.checkNotNull((Object)uri2);
            return contentResolver.openAssetFileDescriptor(uri2, FileUtils.MODE_READ_ONLY);
        }

        private final ContentResolver getContentResolver() {
            ContentResolver contentResolver = TUpdate.Companion.getContext().getContentResolver();
            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContext().contentResolver");
            return contentResolver;
        }

        private final String getExtStoragePath() {
            String string2 = Environment.getExternalStorageDirectory().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalStorageDirectory().absolutePath");
            return string2;
        }

        private final String getExtDownloadsPath() {
            String string2 = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalStoragePublic\u2026            .absolutePath");
            return string2;
        }

        private final String getExtPicturesPath() {
            String string2 = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalStoragePublic\u2026            .absolutePath");
            return string2;
        }

        private final String getExtDCIMPath() {
            String string2 = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalStoragePublic\u2026            .absolutePath");
            return string2;
        }

        @JvmStatic
        public final void close(Closeable ... closeables) {
            Intrinsics.checkNotNullParameter((Object)closeables, (String)"closeables");
            int n = 0;
            int n2 = closeables.length;
            while (n < n2) {
                Closeable io = closeables[n];
                ++n;
                if (io == null) continue;
                try {
                    io.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public final boolean isFileValid(@Nullable String originalMd5, @Nullable File file) {
            CharSequence charSequence = originalMd5;
            boolean isFileValid = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || StringsKt.equals((String)originalMd5, (String)Md5Utils.INSTANCE.getFileMD5(file), (boolean)true);
            Bundle bundle = new Bundle();
            if (isFileValid) {
                bundle.putInt("checkmd5", 1);
            } else {
                bundle.putInt("checkmd5", 0);
            }
            AthenaUtils.INSTANCE.trackOtherEvent("check_package", bundle);
            return isFileValid;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ String access$getExtStoragePath(Companion $this) {
            return $this.getExtStoragePath();
        }

        public static final /* synthetic */ String access$getExtDownloadsPath(Companion $this) {
            return $this.getExtDownloadsPath();
        }

        public static final /* synthetic */ String access$getExtPicturesPath(Companion $this) {
            return $this.getExtPicturesPath();
        }

        public static final /* synthetic */ String access$getExtDCIMPath(Companion $this) {
            return $this.getExtDCIMPath();
        }
    }
}

