/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.config;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.tupdate.TUpdateInner;
import com.cloud.tupdate.bean.BaseResponse;
import com.cloud.tupdate.bean.SdkConfigInfo;
import com.cloud.tupdate.config.ConfigResultListener;
import com.cloud.tupdate.net.network.HttpRequestor;
import com.cloud.tupdate.utils.AdLogUtil;
import com.cloud.tupdate.utils.ExecutorUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.transsion.http.impl.StringCallback;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\rB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0014\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/cloud/tupdate/config/AbsConfigStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "requestFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getPackageName", "", "loadForService", "", "configResultListener", "Lcom/cloud/tupdate/config/ConfigResultListener;", "RequestRunnable", "tupdate_release"})
public abstract class AbsConfigStore {
    @NotNull
    private final Context context;
    @NotNull
    private final AtomicBoolean requestFlag;

    protected AbsConfigStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.requestFlag = new AtomicBoolean(false);
    }

    @Nullable
    public String getPackageName() {
        return null;
    }

    @JvmOverloads
    public final void loadForService(@Nullable ConfigResultListener configResultListener) {
        if (this.requestFlag.compareAndSet(false, true)) {
            ExecutorUtils.io().execute(new RequestRunnable(this, configResultListener));
        }
    }

    public static /* synthetic */ void loadForService$default(AbsConfigStore absConfigStore, ConfigResultListener configResultListener, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadForService");
        }
        if ((n & 1) != 0) {
            configResultListener = null;
        }
        absConfigStore.loadForService(configResultListener);
    }

    @JvmOverloads
    public final void loadForService() {
        AbsConfigStore.loadForService$default(this, null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/cloud/tupdate/config/AbsConfigStore$RequestRunnable;", "Ljava/lang/Runnable;", "store", "Lcom/cloud/tupdate/config/AbsConfigStore;", "configResultListener", "Lcom/cloud/tupdate/config/ConfigResultListener;", "(Lcom/cloud/tupdate/config/AbsConfigStore;Lcom/cloud/tupdate/config/ConfigResultListener;)V", "getConfigResultListener", "()Lcom/cloud/tupdate/config/ConfigResultListener;", "run", "", "tupdate_release"})
    public static final class RequestRunnable
    implements Runnable {
        @NotNull
        private final AbsConfigStore store;
        @Nullable
        private final ConfigResultListener configResultListener;

        public RequestRunnable(@NotNull AbsConfigStore store, @Nullable ConfigResultListener configResultListener) {
            Intrinsics.checkNotNullParameter((Object)store, (String)"store");
            this.store = store;
            this.configResultListener = configResultListener;
        }

        public /* synthetic */ RequestRunnable(AbsConfigStore absConfigStore, ConfigResultListener configResultListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                configResultListener = null;
            }
            this(absConfigStore, configResultListener);
        }

        @Nullable
        public final ConfigResultListener getConfigResultListener() {
            return this.configResultListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String configUrl = TUpdateInner.INSTANCE.getDebugMode() ? "https://cloud-config-api-test.shalltry.com/common/cloudconfig/v1/consumer-not-login/configkeyvalue/query/get" : "https://cloud-config-api.shalltry.com/common/cloudconfig/v1/consumer-not-login/configkeyvalue/query/get";
                CharSequence charSequence = this.store.getPackageName();
                String packageName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.store.context.getPackageName() : this.store.getPackageName();
                Object object = new Pair[]{TuplesKt.to((Object)"key", (Object)packageName)};
                Map map = MapsKt.mutableMapOf((Pair[])object);
                AdLogUtil.Log().i("update", Intrinsics.stringPlus((String)"-------- map = ", (Object)map));
                object = HttpRequestor.Companion.getInstance();
                if (object == null) {
                } else {
                    ((HttpRequestor)object).postJSON(configUrl, null, null, map, new StringCallback(this){
                        final /* synthetic */ RequestRunnable this$0;
                        {
                            this.this$0 = $receiver;
                            super(true);
                        }

                        public void onSuccess(int p0, @NotNull String response) {
                            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                            AdLogUtil.Log().i("update", Intrinsics.stringPlus((String)"-------- response = ", (Object)response));
                            if (!StringsKt.contains$default((CharSequence)response, (CharSequence)"error_code", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)response, (CharSequence)"code", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)response, (CharSequence)"data", (boolean)false, (int)2, null)) {
                                BaseResponse responseResult2;
                                BaseResponse baseResponse = responseResult2 = (BaseResponse)new Gson().fromJson(response, new TypeToken<BaseResponse<SdkConfigInfo>>(){}.getType());
                                if (baseResponse == null ? false : baseResponse.getCode() == 0) {
                                    ConfigResultListener configResultListener = this.this$0.getConfigResultListener();
                                    if (configResultListener != null) {
                                        configResultListener.onLoadDataSuccess((SdkConfigInfo)responseResult2.getData());
                                    }
                                } else {
                                    String string;
                                    BaseResponse baseResponse2 = responseResult2;
                                    if (TextUtils.isEmpty((CharSequence)((CharSequence)(baseResponse2 == null ? null : baseResponse2.getMessage())))) {
                                        string = "code isn't 0";
                                    } else {
                                        BaseResponse baseResponse3 = responseResult2;
                                        string = baseResponse3 == null ? null : baseResponse3.getMessage();
                                    }
                                    String message = string;
                                    ConfigResultListener configResultListener = this.this$0.getConfigResultListener();
                                    if (configResultListener != null) {
                                        configResultListener.onLoadDataFailure(1001, message);
                                    }
                                }
                            } else {
                                ConfigResultListener configResultListener = this.this$0.getConfigResultListener();
                                if (configResultListener != null) {
                                    configResultListener.onLoadDataFailure(1002, "gateway failure");
                                }
                            }
                        }

                        public void onFailure(int code, @Nullable String message, @Nullable Throwable p2) {
                            AdLogUtil.Log().i("update", Intrinsics.stringPlus((String)"-------- message = ", (Object)message));
                            AbsConfigStore.access$getRequestFlag$p(RequestRunnable.access$getStore$p(this.this$0)).set(false);
                            ConfigResultListener configResultListener = this.this$0.getConfigResultListener();
                            if (configResultListener != null) {
                                configResultListener.onLoadDataFailure(code, message);
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                AdLogUtil.netLog(Intrinsics.stringPlus((String)"loadForService --> ", (Object)Log.getStackTraceString((Throwable)e)));
            }
            finally {
                this.store.requestFlag.set(false);
            }
        }

        public static final /* synthetic */ AbsConfigStore access$getStore$p(RequestRunnable $this) {
            return $this.store;
        }
    }
}

