/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.tupdate.bean.UpdateContent;
import com.cloud.tupdate.interfaces.IUpdateManager;
import com.cloud.tupdate.net.utils.LogUtil;
import com.cloud.tupdate.utils.AdLogUtil;
import com.cloud.tupdate.utils.AthenaUtils;
import com.transsion.core.deviceinfo.DeviceInfo;
import java.lang.reflect.Method;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\fJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\fJ\"\u0010\u001a\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001c\u0010\u001d\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J&\u0010\"\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010#\u001a\u00020\f\u00a8\u0006$"}, d2={"Lcom/cloud/tupdate/utils/CommonUtils;", "", "()V", "dismissDialog", "", "context", "Landroid/content/Context;", "dialog", "Landroid/app/Dialog;", "updateContent", "Lcom/cloud/tupdate/bean/UpdateContent;", "getAppVersionName", "", "getBrand", "getCountry", "getLocale", "Ljava/util/Locale;", "getMcc", "getPackageInfo", "Landroid/content/pm/PackageInfo;", "getSystemLanguage", "getVersionCode", "", "getVersionName", "handleScoreUrl", "scoreUrl", "handleUpdateUrl", "updateManager", "Lcom/cloud/tupdate/interfaces/IUpdateManager;", "openBrowser", "url", "openPalmStoreHome", "isFromUpgrade", "", "openSchemeUrl", "osVersion", "tupdate_release"})
public final class CommonUtils {
    @NotNull
    public static final CommonUtils INSTANCE = new CommonUtils();

    private CommonUtils() {
    }

    public final void handleScoreUrl(@NotNull Context context, @Nullable String scoreUrl) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = scoreUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        if (StringsKt.startsWith$default((String)scoreUrl, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)scoreUrl, (String)"https://", (boolean)false, (int)2, null)) {
            this.openBrowser(context, scoreUrl);
        } else {
            try {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)scoreUrl));
                if (!(context instanceof Activity)) {
                    intent.addFlags(0x10000000);
                }
                context.startActivity(intent);
            }
            catch (Exception e) {
                this.openPalmStoreHome(context, false);
            }
        }
    }

    public final void handleUpdateUrl(@Nullable UpdateContent updateContent, @NotNull IUpdateManager updateManager, @Nullable Dialog dialog) {
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        UpdateContent updateContent2 = updateContent;
        String updateUrl = updateContent2 == null ? null : updateContent2.getUpdateUrl();
        CharSequence charSequence = updateUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        Context context = updateManager.getContext();
        if (context == null) {
            return;
        }
        Context context2 = context;
        if (StringsKt.startsWith$default((String)updateUrl, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)updateUrl, (String)"https://", (boolean)false, (int)2, null)) {
            this.dismissDialog(context2, dialog, updateContent);
            this.openBrowser(context2, updateUrl);
        } else {
            this.openSchemeUrl(context2, updateContent, dialog);
        }
    }

    private final void openBrowser(Context context, String url) {
        CharSequence charSequence;
        if (context == null || (charSequence = (CharSequence)url) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e(e);
        }
    }

    private final void openSchemeUrl(Context context, UpdateContent updateContent, Dialog dialog) {
        UpdateContent updateContent2 = updateContent;
        String url = updateContent2 == null ? null : updateContent2.getUpdateUrl();
        CharSequence charSequence = url;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || context == null) {
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            this.dismissDialog(context, dialog, updateContent);
            context.startActivity(intent);
        }
        catch (Exception e) {
            this.openPalmStoreHome(context, true);
        }
    }

    private final void openPalmStoreHome(Context context, boolean isFromUpgrade) {
        Bundle bundle = new Bundle();
        bundle.putString("page", isFromUpgrade ? "upgrade" : "score");
        bundle.putString("action", isFromUpgrade ? "upgrade_click" : "score_click");
        bundle.putString("button_type", isFromUpgrade ? "upgrade" : "score");
        bundle.putString("action_url", "http://www.palmplaystore.com/");
        AthenaUtils.INSTANCE.trackOtherEvent("open_palmstore_home", bundle);
        this.openBrowser(context, "http://www.palmplaystore.com/");
    }

    private final void dismissDialog(Context context, Dialog dialog, UpdateContent updateContent) {
        if (updateContent == null) {
            return;
        }
        try {
            if (Intrinsics.areEqual((Object)updateContent.getForce(), (Object)false)) {
                Dialog dialog2 = dialog;
                if (dialog2 != null) {
                    dialog2.dismiss();
                }
            }
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e(e);
        }
    }

    @NotNull
    public final String getAppVersionName(@Nullable Context context) {
        if (context == null) {
            return "";
        }
        String versionName = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            String string = packageInfo.versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageInfo.versionName");
            versionName = string;
            if (((CharSequence)versionName).length() == 0) {
                return "";
            }
        }
        catch (Exception e) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)e));
        }
        return versionName;
    }

    public final int getVersionCode(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageInfo packageInfo = this.getPackageInfo(context);
        try {
            int n;
            PackageInfo packageInfo2 = packageInfo;
            return packageInfo2 == null ? -1 : (n = packageInfo2.versionCode);
        }
        catch (Exception e) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)e));
            return -1;
        }
    }

    @NotNull
    public final String getVersionName(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageInfo packageInfo = this.getPackageInfo(context);
        if (packageInfo != null) {
            String string2 = packageInfo.versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageInfo.versionName");
            string = string2;
        } else {
            string = "";
        }
        return string;
    }

    private final PackageInfo getPackageInfo(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final Locale getLocale() {
        Locale locale = null;
        try {
            locale = Build.VERSION.SDK_INT >= 24 ? LocaleList.getDefault().get(0) : Locale.getDefault();
        }
        catch (Exception e) {
            locale = Locale.getDefault();
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)e));
        }
        return locale;
    }

    @NotNull
    public final String getSystemLanguage() {
        String string;
        Locale locale = this.getLocale();
        if (locale == null) {
            string = "";
        } else {
            string = locale.getLanguage();
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    @NotNull
    public final String getCountry() {
        String country = "";
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[]{String.class, String.class};
            Method get2 = systemProperties.getMethod("get", classArray);
            Object[] objectArray = new Object[]{"persist.sys.oobe_country", "unknown"};
            Object object = get2.invoke(systemProperties, objectArray);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            country = (String)object;
        }
        catch (Exception e) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)e));
        }
        try {
            if (StringsKt.isBlank((CharSequence)country) || Intrinsics.areEqual((Object)"unknown", (Object)country)) {
                Locale locale = this.getLocale();
                country = String.valueOf(locale == null ? null : locale.getCountry());
            }
        }
        catch (Exception e) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)e));
            country = "";
        }
        return country;
    }

    @NotNull
    public final String getMcc() {
        try {
            String string;
            String deviceOperator = DeviceInfo.getSimOperator();
            if (!TextUtils.isEmpty((CharSequence)deviceOperator) && deviceOperator.length() >= 3) {
                Intrinsics.checkNotNullExpressionValue((Object)deviceOperator, (String)"deviceOperator");
                String string2 = deviceOperator.substring(0, 3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string2;
            } else {
                string = "";
            }
            return string;
        }
        catch (Exception e) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)e));
            return "";
        }
    }

    @NotNull
    public final String getBrand() {
        CharSequence charSequence;
        CharSequence charSequence2 = Build.BRAND;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            charSequence = "";
        } else {
            charSequence2 = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"BRAND");
            charSequence = charSequence2;
        }
        return charSequence;
    }

    @NotNull
    public final String osVersion() {
        CharSequence charSequence;
        CharSequence charSequence2 = Build.VERSION.RELEASE;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            charSequence = "";
        } else {
            charSequence2 = Build.VERSION.RELEASE;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"RELEASE");
            charSequence = charSequence2;
        }
        return charSequence;
    }
}

