/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.download;

import android.content.Context;
import android.text.TextUtils;
import com.cloud.tupdate.bean.DownloadEntity;
import com.cloud.tupdate.download.DownloadManager;
import com.cloud.tupdate.download.DownloadTask;
import com.cloud.tupdate.utils.UpdateUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eJ\u0010\u0010\u001b\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u001c\u001a\u00020\u0019J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\n2\b\b\u0002\u0010!\u001a\u00020\u0004H\u0007J\"\u0010\u001f\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\rJ\u0010\u0010$\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\rJ\u000e\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/cloud/tupdate/download/DownloadManager;", "", "()V", "appropriateThreadCount", "", "getAppropriateThreadCount", "()I", "mClient", "Lokhttp3/OkHttpClient;", "mContext", "Landroid/content/Context;", "mCurrentTaskList", "", "", "Lcom/cloud/tupdate/download/DownloadTask;", "mExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "mQueue", "Ljava/util/concurrent/LinkedBlockingDeque;", "Ljava/lang/Runnable;", "mThreadCount", "okHttpClient", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "addTask", "", "task", "cancelTask", "deleteCurrentTaskList", "getTask", "taskId", "init", "context", "threadCount", "isFinishTask", "", "isPauseTask", "resumeTask", "Companion", "alps_release"})
public final class DownloadManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mThreadCount = 1;
    @Nullable
    private LinkedBlockingDeque<Runnable> mQueue;
    @Nullable
    private ThreadPoolExecutor mExecutor;
    @Nullable
    private Map<String, DownloadTask> mCurrentTaskList;
    @Nullable
    private OkHttpClient mClient;
    @Nullable
    private Context mContext;
    @NotNull
    private static final Lazy<DownloadManager> instance$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)Companion.instance.2.INSTANCE);
    public static final int MAX_THREAD_COUNT = 15;

    private DownloadManager() {
    }

    @JvmOverloads
    public final void init(@NotNull Context context, int threadCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.init(context, threadCount, this.getOkHttpClient());
    }

    public static /* synthetic */ void init$default(DownloadManager downloadManager, Context context, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = downloadManager.getAppropriateThreadCount();
        }
        downloadManager.init(context, n);
    }

    private final void init(Context context, int threadCount, OkHttpClient okHttpClient) {
        this.mContext = context;
        this.mThreadCount = threadCount < 1 ? 1 : (threadCount <= 15 ? threadCount : 15);
        ThreadPoolExecutor threadPoolExecutor = this.mExecutor = new ThreadPoolExecutor(this.mThreadCount, this.mThreadCount, 20L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque());
        Intrinsics.checkNotNull((Object)threadPoolExecutor);
        BlockingQueue<Runnable> blockingQueue = threadPoolExecutor.getQueue();
        if (blockingQueue == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.concurrent.LinkedBlockingDeque<java.lang.Runnable>");
        }
        this.mQueue = (LinkedBlockingDeque)blockingQueue;
        this.mCurrentTaskList = new LinkedHashMap();
        this.mClient = okHttpClient;
    }

    public final void addTask(@NotNull DownloadTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DownloadEntity downloadEntity = task.getDownloadEntity();
        if (downloadEntity != null) {
            String string = downloadEntity.getTaskId();
            if (string == null ? false : !StringsKt.isBlank((CharSequence)string)) {
                task.setClient(this.mClient);
                Map<String, DownloadTask> map = this.mCurrentTaskList;
                Intrinsics.checkNotNull(map);
                Map<String, DownloadTask> map2 = map;
                String string2 = downloadEntity.getTaskId();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = string2;
                map2.put(string3, task);
                LinkedBlockingDeque<Runnable> linkedBlockingDeque = this.mQueue;
                Intrinsics.checkNotNull(linkedBlockingDeque);
                if (!linkedBlockingDeque.contains(task)) {
                    ThreadPoolExecutor threadPoolExecutor = this.mExecutor;
                    Intrinsics.checkNotNull((Object)threadPoolExecutor);
                    threadPoolExecutor.execute(task);
                }
            }
        }
    }

    public final void resumeTask(@NotNull DownloadTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.addTask(task);
    }

    public final void cancelTask(@Nullable DownloadTask task) {
        if (task == null) {
            return;
        }
        DownloadEntity entity = task.getDownloadEntity();
        if (entity != null) {
            Map<String, DownloadTask> map;
            if (entity.getTaskStatus() == 2) {
                ThreadPoolExecutor threadPoolExecutor = this.mExecutor;
                Intrinsics.checkNotNull((Object)threadPoolExecutor);
                threadPoolExecutor.remove(task);
            }
            LinkedBlockingDeque<Runnable> linkedBlockingDeque = this.mQueue;
            Intrinsics.checkNotNull(linkedBlockingDeque);
            if (linkedBlockingDeque.contains(task)) {
                LinkedBlockingDeque<Runnable> linkedBlockingDeque2 = this.mQueue;
                Intrinsics.checkNotNull(linkedBlockingDeque2);
                linkedBlockingDeque2.remove(task);
            }
            if ((map = this.mCurrentTaskList) != null) {
                map.remove(task.getDownloadEntity().getTaskId());
            }
            task.cancel();
            if (!TextUtils.isEmpty((CharSequence)entity.getFilePath()) && !TextUtils.isEmpty((CharSequence)entity.getFileName())) {
                File tempFile;
                String string = entity.getFilePath();
                String string2 = entity.getFileName();
                if (string2 == null) {
                    string2 = "";
                }
                if ((tempFile = new File(string, string2)).exists()) {
                    tempFile.delete();
                }
            }
        }
    }

    @Nullable
    public final DownloadTask getTask(@Nullable String taskId) {
        DownloadEntity entity;
        CharSequence charSequence = taskId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || this.mCurrentTaskList == null) {
            return null;
        }
        Map<String, DownloadTask> map = this.mCurrentTaskList;
        Intrinsics.checkNotNull(map);
        DownloadTask currTask = map.get(taskId);
        if (currTask == null && (entity = UpdateUtils.INSTANCE.getDownLoadData(taskId)) != null) {
            int status = entity.getTaskStatus();
            Context context = this.mContext;
            Intrinsics.checkNotNull((Object)context);
            currTask = new DownloadTask(context, entity);
            if (status != 6) {
                Map<String, DownloadTask> map2 = this.mCurrentTaskList;
                Intrinsics.checkNotNull(map2);
                map2.put(taskId, currTask);
            }
        }
        return currTask;
    }

    public final void deleteCurrentTaskList() {
        if (this.mCurrentTaskList == null) {
            return;
        }
        Map<String, DownloadTask> map = this.mCurrentTaskList;
        Intrinsics.checkNotNull(map);
        map.clear();
    }

    public final boolean isPauseTask(@Nullable String taskId) {
        DownloadEntity entity = UpdateUtils.INSTANCE.getDownLoadData(taskId);
        if (entity != null) {
            File file;
            String string = entity.getFilePath();
            String string2 = entity.getFileName();
            if (string2 == null) {
                string2 = "";
            }
            if ((file = new File(string, string2)).exists()) {
                long totalSize = entity.getTotalSize();
                return totalSize > 0L && file.length() < totalSize;
            }
        }
        return false;
    }

    public final boolean isFinishTask(@Nullable String taskId) {
        DownloadEntity entity = UpdateUtils.INSTANCE.getDownLoadData(taskId);
        if (entity != null) {
            File file;
            String string = entity.getFilePath();
            String string2 = entity.getFileName();
            if (string2 == null) {
                string2 = "";
            }
            if ((file = new File(string, string2)).exists()) {
                return file.length() == entity.getTotalSize();
            }
        }
        return false;
    }

    private final int getAppropriateThreadCount() {
        return Runtime.getRuntime().availableProcessors() * 2 + 1;
    }

    private final OkHttpClient getOkHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).build();
    }

    @JvmOverloads
    public final void init(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DownloadManager.init$default(this, context, 0, 2, null);
    }

    public /* synthetic */ DownloadManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/cloud/tupdate/download/DownloadManager$Companion;", "", "()V", "MAX_THREAD_COUNT", "", "instance", "Lcom/cloud/tupdate/download/DownloadManager;", "getInstance", "()Lcom/cloud/tupdate/download/DownloadManager;", "instance$delegate", "Lkotlin/Lazy;", "alps_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DownloadManager getInstance() {
            Lazy lazy = instance$delegate;
            return (DownloadManager)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

