/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tupdate.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.text.TextUtils;
import android.widget.Toast;
import com.cloud.tupdate.R;
import com.cloud.tupdate.TUpdate;
import com.cloud.tupdate.bean.DownloadEntity;
import com.cloud.tupdate.bean.UpdateContent;
import com.cloud.tupdate.bean.UpdateEntity;
import com.cloud.tupdate.download.DownloadManager;
import com.cloud.tupdate.interfaces.IUpdateManager;
import com.cloud.tupdate.utils.AdLogUtil;
import com.cloud.tupdate.utils.ApkInstallUtils;
import com.cloud.tupdate.utils.AthenaUtils;
import com.cloud.tupdate.utils.CommonUtils;
import com.cloud.tupdate.utils.FileUtils;
import com.cloud.tupdate.utils.SharedPreferencesHelper;
import com.tmc.utils.LogUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\b\u0010\u000e\u001a\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0002J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002J \u0010!\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002J \u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010$\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J*\u0010'\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\bH\u0002J\u001c\u0010(\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010)\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010*\u001a\u00020\b2\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010,\u001a\u00020\b2\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010-\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010.\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u0004H\u0002J\u0012\u00103\u001a\u00020\b2\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u00104\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u00105\u001a\u0004\u0018\u0001062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\"\u00107\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010%\u001a\u00020\bJ%\u00108\u001a\u0002H9\"\u0004\b\u0000\u001092\b\u0010:\u001a\u0004\u0018\u0001H92\b\u0010;\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010<J\u001a\u0010=\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010>\u001a\u00020\bJ\u001a\u0010?\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010>\u001a\u00020\bJ\u0010\u0010@\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0004J5\u0010A\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010B\u001a\u0004\u0018\u00010\u00042\u0006\u0010C\u001a\u0002012\n\b\u0002\u0010D\u001a\u0004\u0018\u00010EH\u0002\u00a2\u0006\u0002\u0010FJ\"\u0010G\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010H\u001a\u00020\bJ\u001a\u0010I\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010J\u001a\u00020\bH\u0002J \u0010K\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u000201J3\u0010L\u001a\u00020\f2\b\u0010B\u001a\u0004\u0018\u00010\u00042\u0006\u0010C\u001a\u0002012\u0006\u0010/\u001a\u00020\u00042\n\b\u0002\u0010D\u001a\u0004\u0018\u00010EH\u0002\u00a2\u0006\u0002\u0010MJ\u001a\u0010N\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010)\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010O\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006P"}, d2={"Lcom/cloud/tupdate/utils/UpdateUtils;", "", "()V", "defaultDiskCacheDirPath", "", "getDefaultDiskCacheDirPath", "()Ljava/lang/String;", "isSDCardEnable", "", "()Z", "checkNetwork", "deleteDownLoadData", "", "taskId", "deleteLastAppFile", "getApkFileByDownloadEntity", "Ljava/io/File;", "downloadEntity", "Lcom/cloud/tupdate/bean/DownloadEntity;", "getApkNameByDownloadUrl", "downloadUrl", "getDiskCacheDir", "context", "Landroid/content/Context;", "uniqueName", "getDownLoadData", "getLastUpdateTaskId", "handleInstallDialog", "updateEntity", "Lcom/cloud/tupdate/bean/UpdateEntity;", "updateManager", "Lcom/cloud/tupdate/interfaces/IUpdateManager;", "currentTaskId", "handleInstallDialogByManual", "handleNormalUpdate", "handleNotForceUpdate", "handleNotForceUpdateByManual", "isManualCheck", "handleScoreDialog", "handleUpdateDialog", "installApkFile", "apkFile", "isIgnoreInstallDialog", "version", "isIgnoreUpgradeDialog", "isShowScoreDialogByTime", "isShowUpdateDialog", "judgeKey", "date", "", "isShowUpdateDialogByTime", "isShowedScoreDialog", "onInstallApk", "updateContent", "Lcom/cloud/tupdate/bean/UpdateContent;", "processUpdateEntity", "requireNonNull", "T", "nonObject", "message", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "saveIgnoreInstallDialog", "isIgnore", "saveIgnoreUpgradeDialog", "saveLastUpdateTaskId", "saveScoreRecord", "updateVersion", "intervalDayIndex", "timeMillis", "", "(Landroid/content/Context;Ljava/lang/String;ILjava/lang/Long;)V", "saveScoreRecordByVersion", "isClickScore", "saveShowScoreDialogValue", "isShowScoreDialog", "saveUpdateDay", "saveUpdateRecord", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/Long;)V", "startInstallApk", "updateDownLoadData", "alps_release"})
public final class UpdateUtils {
    @NotNull
    public static final UpdateUtils INSTANCE = new UpdateUtils();

    private UpdateUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final void processUpdateEntity(@Nullable UpdateEntity updateEntity, @NotNull IUpdateManager updateManager, boolean isManualCheck) {
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        if (updateEntity == null) {
            return;
        }
        boolean lastShowDialogFlag = SharedPreferencesHelper.INSTANCE.getInstance().getBoolean("show_dialog_flag", false);
        if (lastShowDialogFlag) {
            UpdateContent updateContent = updateEntity.getUpdateContent();
            if (updateContent == null ? false : Intrinsics.areEqual((Object)updateContent.getShowDialog(), (Object)false)) {
                AthenaUtils.INSTANCE.trackInstallStatus();
            }
        }
        UpdateContent updateContent = updateEntity.getUpdateContent();
        AdLogUtil.Log().i("update", Intrinsics.stringPlus((String)"\u5b9a\u5411\u6761\u4ef6\u7ed3\u679c = ", (Object)(updateContent == null ? null : updateContent.getCriteriaResult())));
        UpdateContent updateContent2 = updateEntity.getUpdateContent();
        if (updateContent2 != null) {
            Boolean bl = updateContent2.getShowDialog();
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                if (it) {
                    String string2;
                    AthenaUtils athenaUtils = AthenaUtils.INSTANCE;
                    Context context = updateManager.getContext();
                    if (context == null) {
                        string2 = null;
                    } else {
                        void context2;
                        Context context3 = context;
                        AthenaUtils athenaUtils2 = athenaUtils;
                        boolean bl3 = false;
                        string2 = CommonUtils.INSTANCE.getVersionName((Context)context2);
                        athenaUtils = athenaUtils2;
                    }
                    athenaUtils.trackNeedUpdate(string2, updateEntity.getUpdateContent().getUpdateVersion());
                }
                SharedPreferencesHelper.INSTANCE.getInstance().putBoolean("show_dialog_flag", it);
            }
        }
        UpdateEntity it = updateEntity;
        boolean bl = false;
        if (updateEntity.getUpdateContent() != null && Intrinsics.areEqual((Object)updateEntity.getUpdateContent().getShowDialog(), (Object)true) && Intrinsics.areEqual((Object)updateEntity.getUpdateContent().getForce(), (Object)true)) {
            AdLogUtil.Log().i("update", "\u5f3a\u5236\u5347\u7ea7");
            INSTANCE.deleteLastAppFile();
            updateManager.findNewVersion(updateEntity, updateManager, isManualCheck);
        } else if (isManualCheck) {
            INSTANCE.handleNotForceUpdateByManual(updateEntity, updateManager, isManualCheck);
        } else {
            INSTANCE.handleNotForceUpdate(updateEntity, updateManager);
        }
    }

    public static /* synthetic */ void processUpdateEntity$default(UpdateUtils updateUtils, UpdateEntity updateEntity, IUpdateManager iUpdateManager, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        updateUtils.processUpdateEntity(updateEntity, iUpdateManager, bl);
    }

    private final void handleNotForceUpdate(UpdateEntity updateEntity, IUpdateManager updateManager) {
        String string2;
        UpdateContent updateContent = updateEntity.getUpdateContent();
        if (updateContent == null) {
            string2 = "";
        } else {
            string2 = updateContent.getUpdateUrl();
            if (string2 == null) {
                string2 = "";
            }
        }
        String updateUrl = string2;
        String currentTaskId = String.valueOf(updateUrl.hashCode());
        if (DownloadManager.Companion.getInstance().isFinishTask(currentTaskId)) {
            this.handleInstallDialog(updateEntity, updateManager, currentTaskId);
        } else if (updateEntity.getUpdateContent() != null && Intrinsics.areEqual((Object)updateEntity.getUpdateContent().getShowDialog(), (Object)true) && !this.isIgnoreUpgradeDialog(updateEntity.getUpdateContent().getUpdateVersion())) {
            this.handleNormalUpdate(updateEntity, updateManager, currentTaskId);
        } else {
            this.handleScoreDialog(updateEntity, updateManager);
        }
    }

    private final void handleNotForceUpdateByManual(UpdateEntity updateEntity, IUpdateManager updateManager, boolean isManualCheck) {
        String string2;
        UpdateContent updateContent = updateEntity.getUpdateContent();
        if (updateContent == null) {
            string2 = "";
        } else {
            string2 = updateContent.getUpdateUrl();
            if (string2 == null) {
                string2 = "";
            }
        }
        String updateUrl = string2;
        String currentTaskId = String.valueOf(updateUrl.hashCode());
        if (DownloadManager.Companion.getInstance().isFinishTask(currentTaskId)) {
            this.handleInstallDialogByManual(updateEntity, updateManager, currentTaskId);
        } else if (updateEntity.getUpdateContent() != null && Intrinsics.areEqual((Object)updateEntity.getUpdateContent().getShowDialog(), (Object)true)) {
            AdLogUtil.Log().i("update", "\u624b\u52a8\u666e\u901a\u5347\u7ea7");
            this.handleUpdateDialog(updateEntity, updateManager, currentTaskId, isManualCheck);
        }
    }

    private final void handleInstallDialogByManual(UpdateEntity updateEntity, IUpdateManager updateManager, String currentTaskId) {
        UpdateContent updateContent = updateEntity.getUpdateContent();
        if (updateContent == null ? false : Intrinsics.areEqual((Object)updateContent.getShowDialog(), (Object)false)) {
            this.deleteLastAppFile();
        } else {
            File apkFile = this.getApkFileByDownloadEntity(this.getDownLoadData(currentTaskId));
            UpdateContent updateContent2 = updateEntity.getUpdateContent();
            if (FileUtils.Companion.isFileValid((String)(updateContent2 == null ? null : updateContent2.getEncryptedPackage()), apkFile)) {
                updateManager.showInstallDialog(updateEntity, this.getDownLoadData(currentTaskId), updateManager);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleInstallDialog(UpdateEntity updateEntity, IUpdateManager updateManager, String currentTaskId) {
        int day = Calendar.getInstance().get(5);
        UpdateContent updateContent = updateEntity.getUpdateContent();
        if (updateContent == null ? false : Intrinsics.areEqual((Object)updateContent.getShowDialog(), (Object)false)) {
            this.deleteLastAppFile();
            this.handleScoreDialog(updateEntity, updateManager);
            return;
        }
        File apkFile = this.getApkFileByDownloadEntity(this.getDownLoadData(currentTaskId));
        UpdateContent updateContent2 = updateEntity.getUpdateContent();
        if (!this.isIgnoreInstallDialog((String)(updateContent2 == null ? null : updateContent2.getUpdateVersion()))) {
            UpdateContent updateContent3 = updateEntity.getUpdateContent();
            if (FileUtils.Companion.isFileValid((String)(updateContent3 == null ? null : updateContent3.getEncryptedPackage()), apkFile)) {
                UpdateContent updateContent4 = updateEntity.getUpdateContent();
                if ((updateContent4 == null ? null : updateContent4.getUpdateInterval()) != null && !((Collection)updateEntity.getUpdateContent().getUpdateInterval()).isEmpty()) {
                    if (this.isShowUpdateDialogByTime(updateEntity, "install_record")) {
                        updateManager.showInstallDialog(updateEntity, this.getDownLoadData(currentTaskId), updateManager);
                        return;
                    }
                    this.handleScoreDialog(updateEntity, updateManager);
                    return;
                }
                if (this.isShowUpdateDialog(updateManager.getContext(), "install_day", day)) {
                    updateManager.showInstallDialog(updateEntity, this.getDownLoadData(currentTaskId), updateManager);
                    return;
                }
                this.handleScoreDialog(updateEntity, updateManager);
                return;
            }
        }
        this.handleScoreDialog(updateEntity, updateManager);
    }

    private final void handleNormalUpdate(UpdateEntity updateEntity, IUpdateManager updateManager, String currentTaskId) {
        int day = Calendar.getInstance().get(5);
        UpdateContent updateContent = updateEntity.getUpdateContent();
        if ((updateContent == null ? null : updateContent.getUpdateInterval()) != null && !((Collection)updateEntity.getUpdateContent().getUpdateInterval()).isEmpty()) {
            if (this.isShowUpdateDialogByTime(updateEntity, "upgrade_record")) {
                AdLogUtil.Log().i("update", "\u6839\u636e\u65f6\u95f4\u95f4\u9694\u7684\u81ea\u52a8\u666e\u901a\u5347\u7ea7");
                UpdateUtils.handleUpdateDialog$default(this, updateEntity, updateManager, currentTaskId, false, 8, null);
            } else {
                AthenaUtils.INSTANCE.trackNoShowDialogReason(2);
                this.handleScoreDialog(updateEntity, updateManager);
            }
        } else if (this.isShowUpdateDialog(updateManager.getContext(), "tupdate_update_day", day)) {
            AdLogUtil.Log().i("update", "\u975e\u65f6\u95f4\u95f4\u9694\u7684\u81ea\u52a8\u666e\u901a\u5347\u7ea7");
            UpdateUtils.handleUpdateDialog$default(this, updateEntity, updateManager, currentTaskId, false, 8, null);
        } else {
            AthenaUtils.INSTANCE.trackNoShowDialogReason(3);
            this.handleScoreDialog(updateEntity, updateManager);
        }
    }

    private final void handleUpdateDialog(UpdateEntity updateEntity, IUpdateManager updateManager, String currentTaskId, boolean isManualCheck) {
        if (!Intrinsics.areEqual((Object)this.getLastUpdateTaskId(), (Object)currentTaskId)) {
            this.deleteLastAppFile();
        }
        updateManager.findNewVersion(updateEntity, updateManager, isManualCheck);
    }

    static /* synthetic */ void handleUpdateDialog$default(UpdateUtils updateUtils, UpdateEntity updateEntity, IUpdateManager iUpdateManager, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        updateUtils.handleUpdateDialog(updateEntity, iUpdateManager, string2, bl);
    }

    private final void handleScoreDialog(UpdateEntity updateEntity, IUpdateManager updateManager) {
        String updateVersion;
        UpdateContent updateContent = updateEntity.getUpdateContent();
        String string2 = updateVersion = updateContent == null ? null : updateContent.getUpdateVersion();
        if (updateEntity.getAppScoreContent() != null) {
            UpdateContent updateContent2 = updateEntity.getUpdateContent();
            if (updateContent2 == null ? false : Intrinsics.areEqual((Object)updateContent2.getShowDialog(), (Object)false)) {
                if (Intrinsics.areEqual((Object)updateEntity.getAppScoreContent().getShowAfterUpdate(), (Object)true)) {
                    AdLogUtil.Log().i("update", "\u5347\u7ea7\u540e\u81ea\u52a8\u5f39\u8bc4\u5206 \u5f00\u5173 = true");
                    if (!this.isShowedScoreDialog(updateVersion)) {
                        AdLogUtil.Log().i("update", "\u5347\u7ea7\u540e\u81ea\u52a8\u5f39\u8bc4\u5206\u5f39\u6846");
                        updateManager.showScoreDialog(updateEntity, updateManager);
                        this.saveScoreRecord(TUpdate.Companion.getContext(), updateVersion, -1, System.currentTimeMillis());
                    } else if (this.isShowScoreDialogByTime(TUpdate.Companion.getContext(), updateEntity)) {
                        AdLogUtil.Log().i("update", "\u5347\u7ea7\u540e\u6839\u636e\u65f6\u95f4\u95f4\u9694\u5f39\u8bc4\u5206\u5f39\u6846");
                        updateManager.showScoreDialog(updateEntity, updateManager);
                    }
                    this.saveShowScoreDialogValue(updateVersion, true);
                } else if (this.isShowScoreDialogByTime(TUpdate.Companion.getContext(), updateEntity)) {
                    AdLogUtil.Log().i("update", "\u5347\u7ea7\u540e\u5f39\u8bc4\u5206\u5f15\u5bfc\u5173\u95ed\uff0c\u6839\u636e\u65f6\u95f4\u95f4\u9694\u5f39\u8bc4\u5206\u5f39\u6846");
                    updateManager.showScoreDialog(updateEntity, updateManager);
                }
            }
        }
    }

    private final void saveShowScoreDialogValue(String version, boolean isShowScoreDialog) {
        CharSequence charSequence = version;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String isShowScoreDialogValue = SharedPreferencesHelper.INSTANCE.getInstance().getString("is_show_After_Update", "");
        AdLogUtil.Log().i("update", Intrinsics.stringPlus((String)"saveShowScoreDialogValue --> isShowScoreDialogValue = ", (Object)isShowScoreDialogValue));
        CharSequence charSequence2 = isShowScoreDialogValue;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            SharedPreferencesHelper.INSTANCE.getInstance().putString("is_show_After_Update", version + '-' + isShowScoreDialog);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)isShowScoreDialogValue, (String)"isShowScoreDialogValue");
        String[] stringArray = new String[]{"-"};
        List isShowScoreList = StringsKt.split$default((CharSequence)isShowScoreDialogValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!Intrinsics.areEqual((Object)version, isShowScoreList.get(0))) {
            SharedPreferencesHelper.INSTANCE.getInstance().putString("is_show_After_Update", version + '-' + isShowScoreDialog);
        }
    }

    private final boolean isShowedScoreDialog(String version) {
        AdLogUtil.Log().i("update", Intrinsics.stringPlus((String)"version = ", (Object)version));
        CharSequence charSequence = version;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String isShowScoreDialogValue = SharedPreferencesHelper.INSTANCE.getInstance().getString("is_show_After_Update", "");
        AdLogUtil.Log().i("update", Intrinsics.stringPlus((String)"isShowScoreDialogValue = ", (Object)isShowScoreDialogValue));
        CharSequence charSequence2 = isShowScoreDialogValue;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)isShowScoreDialogValue, (String)"isShowScoreDialogValue");
        String[] stringArray = new String[]{"-"};
        List isShowScoreList = StringsKt.split$default((CharSequence)isShowScoreDialogValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return isShowScoreList.size() == 2 ? (Intrinsics.areEqual((Object)version, isShowScoreList.get(0)) ? Boolean.parseBoolean((String)isShowScoreList.get(1)) : false) : false;
    }

    public final <T> T requireNonNull(@Nullable T nonObject, @Nullable String message) {
        if (nonObject == null) {
            throw new NullPointerException(message);
        }
        return nonObject;
    }

    public final boolean checkNetwork() {
        Object object = TUpdate.Companion.getGet().getApplication().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivity = (ConnectivityManager)object;
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getApkNameByDownloadUrl(@NotNull String downloadUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
        if (TextUtils.isEmpty((CharSequence)downloadUrl)) {
            string2 = "temp_" + System.currentTimeMillis() + ".apk";
        } else {
            void var2_3;
            String string3 = downloadUrl.substring(StringsKt.lastIndexOf$default((CharSequence)downloadUrl, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String appName = string3;
            if (!StringsKt.endsWith$default((String)appName, (String)".apk", (boolean)false, (int)2, null)) {
                appName = "temp_" + System.currentTimeMillis() + ".apk";
            }
            string2 = var2_3;
        }
        return string2;
    }

    private final String getDiskCacheDir(Context context, String uniqueName) {
        boolean createDir;
        String string2;
        String string3;
        if (this.isSDCardEnable() && context.getExternalCacheDir() != null) {
            File file = context.getExternalCacheDir();
            Intrinsics.checkNotNull((Object)file);
            string3 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            context.ex\u2026CacheDir!!.path\n        }");
            string2 = string3;
        } else {
            string3 = context.getCacheDir().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            context.cacheDir.path\n        }");
            string2 = string3;
        }
        String cachePath = string2;
        String filePath = cachePath + File.separator + uniqueName;
        File file = new File(filePath);
        if (!file.exists() && (createDir = file.mkdirs())) {
            LogUtil.INSTANCE.d("create file dir success");
        }
        return filePath;
    }

    @NotNull
    public final String getDefaultDiskCacheDirPath() {
        return this.getDiskCacheDir((Context)TUpdate.Companion.getGet().getApplication(), "tupdate");
    }

    private final boolean isSDCardEnable() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable();
    }

    public final void saveUpdateDay(@Nullable Context context, @NotNull String judgeKey, int date) {
        Intrinsics.checkNotNullParameter((Object)judgeKey, (String)"judgeKey");
        if (context == null) {
            return;
        }
        SharedPreferencesHelper.INSTANCE.getInstance().putInt(judgeKey, date);
    }

    private final boolean isShowUpdateDialog(Context context, String judgeKey, int date) {
        if (context == null) {
            return true;
        }
        return SharedPreferencesHelper.INSTANCE.getInstance().getInt(judgeKey, 0) != date;
    }

    public final void saveScoreRecordByVersion(@Nullable Context context, @Nullable String version, boolean isClickScore) {
        CharSequence charSequence;
        if (context == null || (charSequence = (CharSequence)version) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        SharedPreferencesHelper.INSTANCE.getInstance().putBoolean(version, isClickScore);
    }

    private final void saveScoreRecord(Context context, String updateVersion, int intervalDayIndex, Long timeMillis) {
        if (context == null || updateVersion == null) {
            return;
        }
        try {
            if (timeMillis == null) {
                String string2 = SharedPreferencesHelper.INSTANCE.getInstance().getString("score_record", "");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SharedPreferencesHelper.\u2026ing(KEY_SCORE_RECORD, \"\")");
                String scoreRecordValue = string2;
                if (StringsKt.isBlank((CharSequence)scoreRecordValue)) {
                    SharedPreferencesHelper.INSTANCE.getInstance().putString("score_record", updateVersion + "#-1#" + System.currentTimeMillis());
                } else {
                    String[] stringArray = new String[]{"#"};
                    List resultList = StringsKt.split$default((CharSequence)scoreRecordValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String firstTimeMillisStr = (String)resultList.get(2);
                    SharedPreferencesHelper.INSTANCE.getInstance().putString("score_record", updateVersion + '#' + intervalDayIndex + '#' + firstTimeMillisStr);
                }
            } else {
                SharedPreferencesHelper.INSTANCE.getInstance().putString("score_record", updateVersion + '#' + intervalDayIndex + '#' + timeMillis);
            }
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e((Throwable)e);
        }
    }

    static /* synthetic */ void saveScoreRecord$default(UpdateUtils updateUtils, Context context, String string2, int n, Long l, int n2, Object object) {
        if ((n2 & 8) != 0) {
            l = null;
        }
        updateUtils.saveScoreRecord(context, string2, n, l);
    }

    private final boolean isShowScoreDialogByTime(Context context, UpdateEntity updateEntity) {
        String string2;
        if (context == null || updateEntity.getAppScoreContent() == null) {
            return false;
        }
        UpdateContent updateContent = updateEntity.getUpdateContent();
        if (updateContent == null) {
            string2 = "";
        } else {
            string2 = updateContent.getUpdateVersion();
            if (string2 == null) {
                string2 = "";
            }
        }
        String currentUpdateVersion = string2;
        String scoreRecordValue = SharedPreferencesHelper.INSTANCE.getInstance().getString("score_record", "");
        if (SharedPreferencesHelper.INSTANCE.getInstance().getBoolean(currentUpdateVersion, false)) {
            return false;
        }
        CharSequence charSequence = scoreRecordValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            UpdateUtils.saveScoreRecord$default(this, context, currentUpdateVersion, -1, null, 8, null);
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)scoreRecordValue, (String)"scoreRecordValue");
        String[] stringArray = new String[]{"#"};
        List resultList = StringsKt.split$default((CharSequence)scoreRecordValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (resultList.size() == 3) {
            String version = (String)resultList.get(0);
            int intervalDayIndex = Integer.parseInt((String)resultList.get(1));
            long firstTimeMillis = Long.parseLong((String)resultList.get(2));
            try {
                if (Intrinsics.areEqual((Object)version, (Object)currentUpdateVersion)) {
                    boolean bl;
                    if (updateEntity.getAppScoreContent().getIntervalDays() == null || updateEntity.getAppScoreContent().getIntervalDays().isEmpty()) {
                        return false;
                    }
                    if (updateEntity.getAppScoreContent().getIntervalDays().size() - 1 >= intervalDayIndex + 1) {
                        int nextIntervalDayIndex = intervalDayIndex + 1;
                        float nextIntervalDayTime = ((Number)updateEntity.getAppScoreContent().getIntervalDays().get(nextIntervalDayIndex)).floatValue() * (float)24 * (float)60 * (float)60 * (float)1000;
                        if ((float)(System.currentTimeMillis() - firstTimeMillis) > nextIntervalDayTime) {
                            UpdateUtils.saveScoreRecord$default(this, context, version, nextIntervalDayIndex, null, 8, null);
                            bl = true;
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                this.saveScoreRecord(context, currentUpdateVersion, -1, System.currentTimeMillis());
                return false;
            }
            catch (Exception e) {
                LogUtil.INSTANCE.e((Throwable)e);
                return false;
            }
        }
        return false;
    }

    public final void onInstallApk(@NotNull Context context, @Nullable UpdateContent updateContent, @Nullable DownloadEntity downloadEntity) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (downloadEntity == null) {
            return;
        }
        File apkFile = this.getApkFileByDownloadEntity(downloadEntity);
        UpdateContent updateContent2 = updateContent;
        if (FileUtils.Companion.isFileValid((String)(updateContent2 == null ? null : updateContent2.getEncryptedPackage()), apkFile)) {
            this.startInstallApk(context, apkFile);
        } else {
            this.deleteLastAppFile();
            Toast.makeText((Context)context, (int)R.string.text_update_md5_fail, (int)1).show();
        }
    }

    private final void startInstallApk(Context context, File apkFile) {
        if (apkFile == null) {
            return;
        }
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"\u5f00\u59cb\u5b89\u88c5apk\u6587\u4ef6, \u6587\u4ef6\u8def\u5f84:", (Object)apkFile.getAbsolutePath()));
        this.installApkFile(context, apkFile);
    }

    private final boolean installApkFile(Context context, File apkFile) {
        try {
            if (context == null || apkFile == null) {
                return false;
            }
            return ApkInstallUtils.Companion.install(context, apkFile);
        }
        catch (IOException e) {
            LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"An error occurred while install apk:", (Object)e.getMessage()));
            return false;
        }
    }

    private final File getApkFileByDownloadEntity(DownloadEntity downloadEntity) {
        if (downloadEntity == null) {
            return null;
        }
        String string2 = downloadEntity.getFilePath();
        if (string2 == null) {
            string2 = "";
        }
        String apkCachePath = string2;
        String appName = downloadEntity.getFileName();
        return new File(apkCachePath + File.separator + appName);
    }

    public final void updateDownLoadData(@Nullable String taskId, @Nullable DownloadEntity downloadEntity) {
        CharSequence charSequence;
        if (downloadEntity == null || (charSequence = (CharSequence)taskId) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        SharedPreferencesHelper.INSTANCE.getInstance().putObject(taskId, (Serializable)downloadEntity);
    }

    @Nullable
    public final DownloadEntity getDownLoadData(@Nullable String taskId) {
        CharSequence charSequence = taskId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        Object resultObject = SharedPreferencesHelper.INSTANCE.getInstance().contains(taskId) ? SharedPreferencesHelper.INSTANCE.getInstance().getObject(taskId, null) : null;
        return resultObject != null ? (DownloadEntity)resultObject : null;
    }

    public final void deleteDownLoadData(@Nullable String taskId) {
        CharSequence charSequence = taskId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        SharedPreferencesHelper.INSTANCE.getInstance().remove(taskId);
    }

    public final void saveLastUpdateTaskId(@Nullable String taskId) {
        if (taskId == null) {
            return;
        }
        SharedPreferencesHelper.INSTANCE.getInstance().putString("last_update_task_id", taskId);
    }

    private final String getLastUpdateTaskId() {
        return SharedPreferencesHelper.INSTANCE.getInstance().getString("last_update_task_id", "");
    }

    public final void saveIgnoreInstallDialog(@Nullable String version, boolean isIgnore) {
        CharSequence charSequence = version;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        SharedPreferencesHelper.INSTANCE.getInstance().putString("ignore_install_dialog", version + '-' + isIgnore);
    }

    public static /* synthetic */ void saveIgnoreInstallDialog$default(UpdateUtils updateUtils, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        updateUtils.saveIgnoreInstallDialog(string2, bl);
    }

    private final boolean isIgnoreInstallDialog(String version) {
        CharSequence charSequence = version;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String ignoreInstallDialogValue = SharedPreferencesHelper.INSTANCE.getInstance().getString("ignore_install_dialog", "");
        CharSequence charSequence2 = ignoreInstallDialogValue;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ignoreInstallDialogValue, (String)"ignoreInstallDialogValue");
        String[] stringArray = new String[]{"-"};
        List ignoreList = StringsKt.split$default((CharSequence)ignoreInstallDialogValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return ignoreList.size() == 2 ? (Intrinsics.areEqual((Object)version, ignoreList.get(0)) ? Boolean.parseBoolean((String)ignoreList.get(1)) : false) : false;
    }

    public final void saveIgnoreUpgradeDialog(@Nullable String version, boolean isIgnore) {
        CharSequence charSequence = version;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        SharedPreferencesHelper.INSTANCE.getInstance().putString("ignore_upgrade_dialog", version + '-' + isIgnore);
    }

    public static /* synthetic */ void saveIgnoreUpgradeDialog$default(UpdateUtils updateUtils, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        updateUtils.saveIgnoreUpgradeDialog(string2, bl);
    }

    private final boolean isIgnoreUpgradeDialog(String version) {
        boolean bl;
        CharSequence charSequence = version;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String ignoreInstallDialogValue = SharedPreferencesHelper.INSTANCE.getInstance().getString("ignore_upgrade_dialog", "");
        CharSequence charSequence2 = ignoreInstallDialogValue;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ignoreInstallDialogValue, (String)"ignoreInstallDialogValue");
        String[] stringArray = new String[]{"-"};
        List ignoreList = StringsKt.split$default((CharSequence)ignoreInstallDialogValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (ignoreList.size() == 2) {
            if (Intrinsics.areEqual((Object)version, ignoreList.get(0))) {
                boolean result = Boolean.parseBoolean((String)ignoreList.get(1));
                if (result) {
                    AthenaUtils.INSTANCE.trackNoShowDialogReason(1);
                }
                return result;
            }
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void deleteLastAppFile() {
        String lastTaskId = this.getLastUpdateTaskId();
        DownloadEntity entity = this.getDownLoadData(lastTaskId);
        if (entity != null) {
            try {
                File file;
                String string2 = entity.getFilePath();
                String string3 = entity.getFileName();
                if (string3 == null) {
                    string3 = "";
                }
                if ((file = new File(string2, string3)).exists()) {
                    file.delete();
                    this.deleteDownLoadData(lastTaskId);
                    DownloadManager.Companion.getInstance().deleteCurrentTaskList();
                }
            }
            catch (Exception e) {
                LogUtil.INSTANCE.e((Throwable)e);
            }
        }
    }

    private final void saveUpdateRecord(String updateVersion, int intervalDayIndex, String judgeKey, Long timeMillis) {
        if (updateVersion == null) {
            return;
        }
        try {
            if (timeMillis == null) {
                String string2 = SharedPreferencesHelper.INSTANCE.getInstance().getString(judgeKey, "");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SharedPreferencesHelper.\u2026e.getString(judgeKey, \"\")");
                String updateRecordValue = string2;
                if (StringsKt.isBlank((CharSequence)updateRecordValue)) {
                    SharedPreferencesHelper.INSTANCE.getInstance().putString(judgeKey, updateVersion + "#-1#" + System.currentTimeMillis());
                } else {
                    String[] stringArray = new String[]{"#"};
                    List resultList = StringsKt.split$default((CharSequence)updateRecordValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String firstTimeMillisStr = (String)resultList.get(2);
                    SharedPreferencesHelper.INSTANCE.getInstance().putString(judgeKey, updateVersion + '#' + intervalDayIndex + '#' + firstTimeMillisStr);
                }
            } else {
                SharedPreferencesHelper.INSTANCE.getInstance().putString(judgeKey, updateVersion + '#' + intervalDayIndex + '#' + timeMillis);
            }
        }
        catch (Exception e) {
            LogUtil.INSTANCE.e((Throwable)e);
        }
    }

    static /* synthetic */ void saveUpdateRecord$default(UpdateUtils updateUtils, String string2, int n, String string3, Long l, int n2, Object object) {
        if ((n2 & 8) != 0) {
            l = null;
        }
        updateUtils.saveUpdateRecord(string2, n, string3, l);
    }

    private final boolean isShowUpdateDialogByTime(UpdateEntity updateEntity, String judgeKey) {
        String updateRecordValue;
        CharSequence charSequence;
        String currentUpdateVersion;
        if (updateEntity.getUpdateContent() == null) {
            return false;
        }
        String string2 = updateEntity.getUpdateContent().getUpdateVersion();
        if (string2 == null) {
            string2 = currentUpdateVersion = "";
        }
        if ((charSequence = (CharSequence)(updateRecordValue = SharedPreferencesHelper.INSTANCE.getInstance().getString(judgeKey, ""))) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            UpdateUtils.saveUpdateRecord$default(this, currentUpdateVersion, -1, judgeKey, null, 8, null);
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)updateRecordValue, (String)"updateRecordValue");
        String[] stringArray = new String[]{"#"};
        List resultList = StringsKt.split$default((CharSequence)updateRecordValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (resultList.size() == 3) {
            String version = (String)resultList.get(0);
            int intervalDayIndex = Integer.parseInt((String)resultList.get(1));
            long firstTimeMillis = Long.parseLong((String)resultList.get(2));
            try {
                if (Intrinsics.areEqual((Object)version, (Object)currentUpdateVersion)) {
                    boolean bl;
                    if (updateEntity.getUpdateContent().getUpdateInterval() == null || updateEntity.getUpdateContent().getUpdateInterval().isEmpty()) {
                        return false;
                    }
                    if (updateEntity.getUpdateContent().getUpdateInterval().size() - 1 >= intervalDayIndex + 1) {
                        int nextIntervalDayIndex = intervalDayIndex + 1;
                        float nextIntervalDayTime = ((Number)updateEntity.getUpdateContent().getUpdateInterval().get(nextIntervalDayIndex)).floatValue() * (float)24 * (float)60 * (float)60 * (float)1000;
                        if ((float)(System.currentTimeMillis() - firstTimeMillis) > nextIntervalDayTime) {
                            UpdateUtils.saveUpdateRecord$default(this, version, nextIntervalDayIndex, judgeKey, null, 8, null);
                            bl = true;
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                this.saveUpdateRecord(currentUpdateVersion, -1, judgeKey, System.currentTimeMillis());
                return true;
            }
            catch (Exception e) {
                LogUtil.INSTANCE.e((Throwable)e);
                return false;
            }
        }
        return false;
    }
}

