package com.cloud.baobabsland

import android.content.Context
import android.util.Log
import com.cloud.baobabsland.athena.AthenaTracker
import com.cloud.baobabsland.worker.WorkerHelper.setDebug
import com.cloud.baobabsland.worker.WorkerHelper.initUnion
import com.cloud.baobabsland.utils.AdLogUtil
import com.cloud.baobabsland.utils.CommonLogUtil
import com.cloud.baobabsland.utils.CommonUtils
import com.cloud.baobabsland.webview.WebViewManager
import com.transsion.core.CoreUtil
import com.transsion.ga.AthenaAnalytics
import java.lang.Exception

object UnionManager {
    /**
     * 内容联盟sdk初始化
     * @param context 接入方上下文
     * @param unionSetting 内容联盟配置
     */
    @JvmStatic
    fun init(context: Context?, unionSetting: UnionSetting?) {
        if (context == null || unionSetting == null || unionSetting.verifyIllegal()) {
            AthenaTracker.trackInitSdk(0)
            AdLogUtil.Log().e("Galileo call init with illegal parameters")
            return
        }
        CoreUtil.init(context)
        setDebug(unionSetting)
        //提前加载gaid
        CommonUtils.getGAID()
        AthenaTracker.initAthena(context, unionSetting.isDebug)
        try {
            initUnion(context, unionSetting)
            WebViewManager.prepare(context)
            AdLogUtil.Log().i(CommonLogUtil.TAG, "Baobab SDK Version is ${BuildConfig.SDK_VERSION}")
        } catch (e: Exception) {
            AthenaTracker.trackInitSdk(0)
            AdLogUtil.Log().e(Log.getStackTraceString(e))
        }
    }

    /**
     * 开启/关闭敏感信息收集
     * @param isEnable  true:开启收集，false：关闭收集
     */
    @JvmStatic
    fun enable(isEnable: Boolean) {
        try {
            AthenaAnalytics.enable(isEnable)
        } catch (e: Exception) {
            AdLogUtil.Log().e(Log.getStackTraceString(e))
        }
    }
}