package com.cloud.baobabsland

import android.text.TextUtils

/**
 * 全局配置类
 */
class UnionSetting private constructor(builder: Builder) {
    private val mBuilder: Builder?

    /**
     * 参数是否有效
     */
    fun verifyIllegal(): Boolean {
        return if (mBuilder != null) {
            TextUtils.isEmpty(mBuilder.appId)
        } else true
    }

    /**
     * 获取appId
     * @return
     */
    val appId: String?
        get() = if (mBuilder != null) {
            mBuilder.appId
        } else ""

    /**
     * 获取当前运行的环境
     */
    val isDebug: Boolean
        get() = mBuilder?.isDebug ?: false

    /** 获取日志开关  */
    val isLogDebug: Boolean
        get() = mBuilder?.isLogDebug ?: false

    class Builder {
        var appId: String? = null
            private set
        var isDebug = false
            private set

        //log开关
        var isLogDebug = false
            private set

        fun setAppId(appId: String?): Builder {
            this.appId = appId
            return this
        }

        fun setDebug(isDebug: Boolean): Builder {
            this.isDebug = isDebug
            return this
        }

        fun setLogDebug(isLogDebug: Boolean): Builder {
            this.isLogDebug = isLogDebug
            return this
        }

        fun build(): UnionSetting {
            return UnionSetting(this)
        }
    }

    init {
        mBuilder = builder
    }
}