package com.cloud.baobabsland.bean

import android.util.Log
import com.cloud.baobabsland.BuildConfig
import com.cloud.baobabsland.bean.request.*
import com.cloud.baobabsland.constant.Constants
import com.cloud.baobabsland.utils.AdLogUtil
import com.cloud.baobabsland.utils.CommonLogUtil
import com.cloud.baobabsland.utils.CommonUtils
import com.cloud.baobabsland.utils.PreferencesHelper
import com.cloud.baobabsland.utils.gsonutil.GsonUtil
import com.transsion.core.CoreUtil

object PostBody {
    private var sBaseBody: BaseBody? = null

    private fun initParam() {
        if (sBaseBody == null) {
            val baseBody = BaseBody()
            baseBody.pkgName = CoreUtil.getContext().packageName
            baseBody.sdkVersion = BuildConfig.SDK_VERSION
            baseBody.phoneModel = CommonUtils.getModel()
            baseBody.gaid = CommonUtils.getGAID()
            baseBody.mcc = CommonUtils.getMcc()
            baseBody.ts = System.currentTimeMillis()
            baseBody.udid = CommonUtils.getUDID()
            baseBody.udidType = PreferencesHelper.instance.getInt(Constants.KeyName.KEY_UDID_TYPE)
            try {
                baseBody.vaid = CommonUtils.getVAID()
            } catch (e: Exception) {
                baseBody.vaid = ""
                AdLogUtil.Log().e(Log.getStackTraceString(e))
            }
            sBaseBody = baseBody
        }
    }

    /**
     * 云控接口需要的body数据
     * @param appIdOrKey 媒体方的appId 或者 key
     */
    @JvmStatic
    fun getConfigPostBody(appIdOrKey: String?): String {
        try {
            initParam()
            val configRequestBody = ConfigRequestBody(sBaseBody)
            configRequestBody.appId = appIdOrKey
            configRequestBody.key = CoreUtil.getContext().packageName + "-" + appIdOrKey
            return GsonUtil.toJson(configRequestBody)
        } catch (throwable: Throwable) {
            AdLogUtil.Log().e(Log.getStackTraceString(throwable))
        }
        return ""
    }


    /**
     * sdk总控接口需要的body数据
     * @param appIdOrKey 媒体方的appId 或者 key
     */
    @JvmStatic
    fun getConfigSdkBody(appIdOrKey: String?): String {
        try {
            initParam()
            val configRequestBody = ConfigRequestBody(sBaseBody)
            configRequestBody.key = appIdOrKey
            return GsonUtil.toJson(configRequestBody)
        } catch (throwable: Throwable) {
            AdLogUtil.Log().e(Log.getStackTraceString(throwable))
        }
        return ""
    }

    /**
     * feed列表接口需要的body数据
     * @param appId 媒体方的appId
     */
    @JvmStatic
    fun getFeedListBody(appId: String?): String {
        try {
            initParam()
            val listBody = FeedListBody(sBaseBody)
            listBody.appId = appId
            listBody.channelId = Constants.CommonConstant.CHANNEL_ID //TopNews
            listBody.feedType = 1
            listBody.pullType = 0
            listBody.requestSource = "baobabsland-sdk"
            listBody.requestType = 1
            return GsonUtil.toJson(listBody)
        } catch (e: Exception) {
            AdLogUtil.Log().e(Log.getStackTraceString(e))
        }
        return ""
    }

    /**
     *异步保存不存在的udid的Body数据
     */
    @JvmStatic
    fun getSaveUDIDBody(): String {
        return try {
            initParam()
            val listBody = SaveUDIDBody(sBaseBody)
            listBody.udid = CommonUtils.getUDID()
            listBody.udidType = PreferencesHelper.instance.getInt(Constants.KeyName.KEY_UDID_TYPE)
            AdLogUtil.Log().i(CommonLogUtil.TAG, "udid = ${listBody.udid} , udidType = ${listBody.udidType}")
            GsonUtil.toJson(listBody)
        } catch (e: Exception) {
            ""
        }
    }

    /**
     * 实验数据的获取
     */
    @JvmStatic
    val experimentBody: String
        get() {
            try {
                initParam()
                val experimentBody = ExperimentBody(sBaseBody)
                return GsonUtil.toJson(experimentBody)
            } catch (e: Exception) {
                AdLogUtil.Log().e(Log.getStackTraceString(e))
            }
            return ""
        }
}