package com.cloud.baobabsland.bean.request

import android.text.TextUtils
import com.cloud.baobabsland.utils.CommonUtils
import java.io.Serializable

class FeedListBody(baseBody: BaseBody?) : BaseBody(), Serializable {
    @JvmField
    var appId: String? = null

    //频道ID
    @JvmField
    var channelId = 0

    //内容类型 1: 图文; 2: 视频; 3: 图文+视频 (列表传3)
    @JvmField
    var feedType = 0

    //刷新类型 0: 直接加载; 1: 下拉; 2: 上拉
    @JvmField
    var pullType = 0

    //请求来源：baobabsland-sdk; baobabsland-h5
    @JvmField
    var requestSource: String? = null

    //请求类型 1: feed;2: content
    @JvmField
    var requestType = 0

    init {
        vaid = baseBody?.vaid ?: ""
        pkgName = baseBody?.pkgName ?: ""
        sdkVersion = baseBody?.sdkVersion ?: ""
        phoneModel = baseBody?.phoneModel ?: ""
        ts = baseBody?.ts ?: 0
        mcc = baseBody?.mcc
        gaid = baseBody?.gaid
        udid = baseBody?.udid ?: ""
        udidType = baseBody?.udidType ?: 2
        if (TextUtils.isEmpty(vaid)) {
            vaid = CommonUtils.getVAID()
        }
    }
}