package com.cloud.baobabsland.config

import android.annotation.SuppressLint
import android.content.Context

/**
 * Config组件帮助类
 */
class ConfigHelper private constructor() {

    companion object {

        @SuppressLint("StaticFieldLeak")
        @Volatile
        private var instance: ConfigStore? = null

        /**  ConfigStore单例获取 。*/
        fun getConfigStoreInstance(context: Context): ConfigStore {
            val i = instance
            if (i != null) {
                return i
            }
            return synchronized(this) {
                val i2 = instance
                if (i2 != null) {
                    i2
                } else {
                    val created =  ConfigStore(context)
                    instance = created
                    created
                }

            }
        }

    }
}