package com.cloud.baobabsland.constant

class Constants {
    class ResponseCode {
        companion object {
            /**
             * 响应成功
             */
            const val BUSINESS_SUCCESS_CODE = 0
        }
    }

    class DownPath {
        companion object {
            /** 下载的本地的文件 。  */
            const val OFFLINE_FOLDER_NAME = "offline_union"

            /** 在线数据  */
            const val ONLINE_FOLDER_NAME = "online_union"

            /** 下载的本地的zip文件 。  */
            const val H5_ZIP_FOLDER_NAME = "feed_zip"

            /** feed列表图片文件 。  */
            const val FEED_LIST_IMAGE_NAME = "feed/img"

            /** feed详情图片文件 。  */
            const val FEED_DETAIL_IMAGE_NAME = "content/img"
        }
    }

    class ImageType {
        companion object {
            /** feed列表的image 。 */
            const val FEED_LIST_IMAGE = 0

            /** feed详情的image 。 */
            const val FEED_DETAIL_IMAGE = 1
        }
    }

    class HOST {
        companion object {
            /** DEV环境 。  */
            const val DEV_SERVER_ADDRESS = "http://api-test.baobabsland.com"
            /** PRE环境 。  */
            const val PRE_SERVER_ADDRESS = "http://api-pre.baobabsland.com"
            /** RELEASE环境 。  */
            const val RELEASE_SERVER_ADDRESS = "https://api.baobabsland.com"
            //        String RELEASE_SERVER_ADDRESS = "https://ind-api.baobabsland.com";
            /** TEST环境-OSS 。  */
            const val TEST_OSS_ADDRESS = "https://contentalliance-manage-oss-test.baobabsland.com/"
            /** PRE环境-OSS 。  */
            const val PRE_OSS_ADDRESS = "https://contentalliance-manage-oss-pre.baobabsland.com/"
            /** RELEASE环境-OSS 。  */
            const val RELEASE_OSS_ADDRESS = "https://contentalliance-manage-oss.baobabsland.com/"

            /** feed列表接口 。  */
            const val FEED_LIST_API =
                "/contentalliance/dispatch/consumer-not-login/feed/query/queryOfflineFeeds"

            /** 批量获取层下命中的实验信息 。 */
            const val EXPERIMENT_API =
                "/contentalliance/dispatch/consumer-not-login/abtest/query/getExperimentsByOneId"

            /** 异步保存不存在的udid 。 */
            const val SAVE_UDID_API = "/contentalliance/dispatch/consumer-not-login/uniteidmapping/cmd/asyncSaveIfAbsent"

            /** 离线的host 。  */
            const val OFFLINE_DOMAIN = "appassets.androidplatform.net"

            /** 离线的域名地址 。  */
            const val OFFLINE_ADDRESS = "https://appassets.androidplatform.net"

            /** sdk云控接口  */
            const val SDK_CONFIG_TEST_API =
                "http://cloud-config-api-test.shalltry.com/common/cloudconfig/v1/consumer-not-login/configkeyvalue/query/get"
            const val SDK_CONFIG_PRE_API =
                "https://cloud-config-api-pre.shalltry.com/common/cloudconfig/v1/consumer-not-login/configkeyvalue/query/get"
            const val SDK_CONFIG_API =
                "https://cloud-config-api.shalltry.com/common/cloudconfig/v1/consumer-not-login/configkeyvalue/query/get"
        }
    }

    class H5Address {
        companion object {
            /** 首页地址 。  */
            const val HOME_H5_TEST = "https://h5-test.baobabsland.com/#/"
            const val HOME_H5_PRE = "https://h5-pre.baobabsland.com/#/"
            const val HOME_H5_RELEASE = "https://h5.baobabsland.com/#/"
            //        String HOME_H5_RELEASE = "https://ind-h5.baobabsland.com/#/";
            /** 详情地址关键字 。  */
            const val DETAIL_PAGE = "#/detail"

            /** 视频页面关键字  */
            const val MEDIA_PAGE = "#/media"

            /** 首页Host 。  */
            const val OFFLINE_DOMAIN_TEST = "h5-test.baobabsland.com"
            const val OFFLINE_DOMAIN_PRE = "h5-pre.baobabsland.com"
            const val OFFLINE_DOMAIN_RELEASE = "h5.baobabsland.com"
        //        String OFFLINE_DOMAIN_RELEASE = "ind-h5.baobabsland.com";
            /** 离线列表页区别 */
            const val OFFLINE_LOAD_PAGE = "feed_zip/index.html"
        }
    }

    class KeyName {
        companion object {
            /** 跳转到feed详情的Url  */
            const val KEY_FEED_DETAIL_URL = "feed_detail_url"

            /** 更新的请求日期和次数记录 。  */
            const val KEY_CONFIG_DAILY = "config_daily_day_time"

            /** 是否关闭无网弹框  */
            const val KEY_CLOSE_NET_TIPS = "is_close_net_tips"

            /** 本地存储 。  */
            const val KEY_GAID = "sdk_gaid"
            /** Athena的vaid。 */
            const val KEY_VAID = "union_athena_vaid"
            /** 内容联盟的udid。 */
            const val KEY_UDID = "union_udid"
            /** 内容联盟的udidType。 */
            const val KEY_UDID_TYPE = "union_udid_type"
        }
    }

    class CommonConstant {
        companion object {
            /** 默认的频道Id, 0: topNews 。  */
            const val CHANNEL_ID = 0

            /** 编码格式 。 */
            const val ENCODING_UTF = "UTF-8"

            /** 从cdn获取feed详情数据 。  */
            const val FEED_DETAIL_PATH = "content/json/"

            /** 网络超时时间 。  */
            const val TIMEOUT_IN_MILLIONS = 15 * 1000

            /** 请求feed列表图片结束 。  */
            const val RECEIVER_ACTION = "download_feed_list_end"

            /** Athena的appId  */
            const val APP_ID = "baobabsland"

            /** Athena的tid  */
            const val TID = 3058

            /** sdk初始化 。  */
            const val EVENT_SDK_INIT = "union_sdk_init"

            /** gslb初始化 。  */
            const val EVENT_GSLB_INIT = "gslb_init"

            /** 云控请求判断 。  */
            const val EVENT_CONFIG_REQUEST = "config_request"

            /** 云控请求结果 。  */
            const val EVENT_CONFIG_RESULT = "config_request_result"

            /** 请求下载离线zip包 。  */
            const val EVENT_DOWNLOAD_ZIP = "download_zip"

            /** 下载离线zip包结果 。  */
            const val EVENT_DOWNLOAD_ZIP_RESULT = "download_zip_result"

            /** 下载物料的结果 。  */
            const val EVENT_DOWNLOAD_MATERIAL = "download_material"

            /** 删除缓存数据 。  */
            const val EVENT_DELETE_LOCAL_DATA = "delete_local_data"

            /** 媒体请求页面 。  */
            const val EVENT_MEDIA_CALL_REQUEST = "media_call_request"

            /** 列表数据请求 。  */
            const val EVENT_OFFLINE_FEED_REQUEST = "offline_feed_request"

            /** 列表数据返回 。  */
            const val EVENT_OFFLINE_FEED_RESPONSE = "offline_feed_response"

            /** 详情数据请求 。  */
            const val EVENT_OFFLINE_DETAIL_REQUEST = "offline_detail_request"

            /** 详情数据返回 。  */
            const val EVENT_OFFLINE_DETAIL_RESPONSE = "offline_detail_response"

            /** 显示网络浮层埋点 。  */
            const val EVENT_SHOW_NO_NETWORK_TIPS = "show_no_network_tips"

            /** 关闭网络浮层埋点 。  */
            const val EVENT_CLOSE_NO_NETWORK_TIPS = "close_no_network_tips"

            /** H5页面加载完成埋点 。 */
            const val EVENT_WEB_VIEW_LOAD_FINISH = "webview_load_finish"

            /** H5页面加载url前耗时埋点 。 */
            const val EVENT_WEB_VIEW_LOAD_URL_BEFORE = "webview_load_url_before"
        }
    }
}