package com.cloud.baobabsland.constant

import android.text.TextUtils

class ErrorCode(errorCode: Int, errorMessage: String) {
    val errorCode: Int
    val errorMessage: String

    companion object {
        private const val NETWORK_ERROR_CODE = 9000
        const val UNKNOWN_ERROR_CODE = 10000
        @JvmField
        val NETWORK_ERROR = ErrorCode(NETWORK_ERROR_CODE, "Network Error")
    }

    init {
        var errorMessage = errorMessage
        if (TextUtils.isEmpty(errorMessage)) {
            errorMessage = "empty msg"
        }
        this.errorCode = errorCode
        this.errorMessage = errorMessage
    }
}