package com.cloud.baobabsland.constant

import com.transsion.gslb.GslbSdk

object ServerConfig {
    const val RELEASE = 0
    const val PRE = 1
    const val DEV = 2
    var appModule = RELEASE

    /**
     * 接口请求的域名
     */
    @JvmStatic
    val serverUrl: String
        get() = when(appModule) {
            DEV -> GslbSdk.getDomain(
                Constants.HOST.DEV_SERVER_ADDRESS,
                true
            )
            PRE -> GslbSdk.getDomain(
                Constants.HOST.PRE_SERVER_ADDRESS,
                true
            )
            else -> GslbSdk.getDomain(
                Constants.HOST.RELEASE_SERVER_ADDRESS,
                true
            )
        }

    /**
     * oss的域名
     */
    @JvmStatic
    val ossUrl: String
        get() = when (appModule) {
            DEV -> Constants.HOST.TEST_OSS_ADDRESS
            PRE -> Constants.HOST.PRE_OSS_ADDRESS
            else -> Constants.HOST.RELEASE_OSS_ADDRESS
        }

    /**
     * h5页面地址
     */
    @JvmStatic
    val h5Url: String
        get() = when(appModule) {
            DEV -> GslbSdk.getDomain(
                Constants.H5Address.HOME_H5_TEST,
                true
            )
            PRE -> GslbSdk.getDomain(
                Constants.H5Address.HOME_H5_PRE,
                true
            )
            else -> GslbSdk.getDomain(
                Constants.H5Address.HOME_H5_RELEASE,
                true
            )
        }

    /**
     * h5页面地址
     */
    @JvmStatic
    val h5Host: String
        get() = when(appModule) {
            DEV -> GslbSdk.getDomain(
                    Constants.H5Address.OFFLINE_DOMAIN_TEST,
                    true
                )
            PRE -> GslbSdk.getDomain(
                Constants.H5Address.OFFLINE_DOMAIN_PRE,
                true
            )
            else -> GslbSdk.getDomain(
                Constants.H5Address.OFFLINE_DOMAIN_RELEASE,
                true
            )
        }

    /** sdk云控url  */
    val sdkConfigUrl: String
        get() = when (appModule) {
            DEV -> Constants.HOST.SDK_CONFIG_TEST_API
            PRE -> Constants.HOST.SDK_CONFIG_PRE_API
            else -> Constants.HOST.SDK_CONFIG_API
        }
}