package com.cloud.baobabsland.download;


import com.cloud.baobabsland.utils.AdLogUtil;
import com.cloud.baobabsland.utils.CommonLogUtil;

public class OfflineAdManager {

    private OfflineAdManager() {
    }

    private static class OfflineAdManagerInstance {
        private static final OfflineAdManager INSTANCE = new OfflineAdManager();
    }
    public static OfflineAdManager getInstance() {
        return OfflineAdManagerInstance.INSTANCE;
    }

    public void downloadMaterials(String zipUrl) {
        AdLogUtil.Log().i(CommonLogUtil.TAG, "start download------");
        OfflineDownload.getInstance().downLoad(zipUrl, mLoadCallBack);
    }

    private final OfflineDownload.DownLoadCallBack mLoadCallBack = new OfflineDownload.DownLoadCallBack() {
        @Override
        public void onComplete() {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "onComplete");
        }

        @Override
        public void onCompleteAndTrack() {
            onComplete();
        }
    };

}
