package com.cloud.baobabsland.http.listener;


public abstract class DrawableResponseListener extends ResponseBaseListener {
    protected DrawableResponseListener() {
        super();
    }

    /**
     * 成功回调
     *
     * @param statusCode
     * @param
     */
    public abstract void onRequestSuccess(int statusCode, byte[] data, String filePath);


    /**
     * 解析方法
     *
     * @param statusCode
     * @param data
     * @param isPreCache
     */
    public final void onServerRequestSuccess(int isPreCache, final int statusCode, final byte[] data, final String filePath) {
        if (this.handler != null) {
            this.handler.post(new Runnable() {
                @Override
                public void run() {
                    onRequestSuccess(statusCode, data, filePath);
                }
            });
        } else {
            onRequestSuccess(statusCode, data, null);
        }
    }
}
