package com.cloud.baobabsland.http.listener;

import android.os.Handler;
import android.os.Looper;

import com.cloud.baobabsland.constant.ErrorCode;


public abstract class ResponseBaseListener {

    protected Handler handler;

    public ResponseBaseListener() {
        this(Looper.myLooper());
    }

    private ResponseBaseListener(Looper looper) {
        if (looper != null) {
            this.handler = new ResponderHandler(looper);
        } else {
            this.handler = null;
        }
    }

    private class ResponderHandler extends Handler {
        ResponderHandler(Looper looper) {
            super(looper);
        }
    }

    public void onServerRequestFailure(int statusCode, String responseBody, Throwable throwable) {
        onServerRequestFailure(new ErrorCode(statusCode, "error msg = " + responseBody));
    }

    public void onServerRequestFailure(int statusCode, byte[] responseBody, Throwable throwable) {
        onServerRequestFailure(new ErrorCode(statusCode, "error msg = " + responseBody));
    }

    public void onServerRequestFailure(final ErrorCode adError) {
        if (this.handler != null) {
            this.handler.post(() -> onRequestError(adError));
        } else {
            onRequestError(adError);
        }
    }

    /**
     * 失败回调
     */
    protected abstract void onRequestError(ErrorCode adError);
}
