package com.cloud.baobabsland.manager

import android.app.Activity
import androidx.fragment.app.Fragment
import java.util.*

/**
 * Activity管理类
 */
object ActivityAndFragmentManager {
    private var activityList: LinkedList<Activity> = LinkedList<Activity>()
    private var fragmentList: LinkedList<Fragment> = LinkedList<Fragment>()

    //首次打开FeedFragment是否是FeedActivity,用户操作关闭
    private var isFeedActivityForOpenFeedList = false
    //是否设置过标志位
    private var isMark = false

    /**
     * 添加Activity到集合里
     */
    fun addActivity(activity: Activity) {
        if (!activityList.contains(activity)) {
            activityList.add(activity)
        }
    }

    /**
     * 添加Fragment到集合里
     */
    fun addFragment(fragment: Fragment) {
        if (!fragmentList.contains(fragment)) {
            fragmentList.add(fragment)
        }
    }

    /**
     * 删除集合里的Activity
     */
    fun removeActivity(activity: Activity) {
        if (activityList.contains(activity)) {
            activityList.remove(activity)
        }
    }

    /**
     * 删除集合里的Fragment
     */
    fun removeFragment(fragment: Fragment) {
        if (fragmentList.contains(fragment)) {
            fragmentList.remove(fragment)
        }
        if (fragmentList.size == 0) {
            resetMark()
        }
    }

    /**
     * 关闭集合里所有的activity
     */
    private fun finishAllActivity() {
        for (activity in activityList) {
            activity.finish()
        }
    }

    /**
     * 回退到首页Activity
     */
    fun backHomeActivity() {
        if (isFeedActivityForOpenFeedList) {
            for ((index, activity) in activityList.withIndex()) {
                if (index != 0) {
                    activity.finish()
                }
            }
        } else {
            finishAllActivity()
        }
        resetMark()
    }

    /**
     * 设置标志位
     */
    fun setMarkValue(isFeedActivityForOpenFeedList: Boolean) {
        if (isMark) return

        this.isFeedActivityForOpenFeedList = isFeedActivityForOpenFeedList
        this.isMark = true
    }

    /**
     * 重置标志位
     */
    private fun resetMark() {
        if (fragmentList.size > 1) return

        this.isMark = false
        this.isFeedActivityForOpenFeedList = false
    }
}