package com.cloud.baobabsland.utils;

import java.util.List;
import java.util.Map;

/**
 * 集合工具类
 */
public class CollectionUtils {

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    public static String getUrlParamsByMap(Map<String, ?> map) {
        if (!isNotEmpty(map)) return "";
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            sb.append(entry.getKey())
                    .append("=")
                    .append(entry.getValue())
                    .append("&");
        }

        String s = sb.toString();
        if (s.endsWith("&")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }
}
