package com.cloud.baobabsland.utils

import android.util.Log
import com.cloud.baobabsland.utils.FileUtils.Companion.close
import com.cloud.baobabsland.utils.FileUtils.Companion.getFileInputStream
import com.cloud.baobabsland.utils.FileUtils.Companion.isFileExists
import java.io.File
import java.io.InputStream
import java.lang.Exception
import java.security.MessageDigest

/**
 * MD5加密工具类
 */
object Md5Utils {
    /**
     * 获取文件的MD5值
     */
    fun getFileMD5(file: File?): String {
        if (!isFileExists(file)) {
            return ""
        }
        var fis: InputStream? = null
        return try {
            val digest = MessageDigest.getInstance("MD5")
            fis = getFileInputStream(file)
            val buffer = ByteArray(8192)
            var len: Int
            while (fis!!.read(buffer).also { len = it } != -1) {
                digest.update(buffer, 0, len)
            }
            bytes2Hex(digest.digest())
        } catch (e: Exception) {
            AdLogUtil.Log().e(Log.getStackTraceString(e))
            ""
        } finally {
            close(fis)
        }
    }

    /**
     * 一个byte转为2个hex字符
     *
     * @param data byte数组
     * @return 16进制大写字符串
     */
    private fun bytes2Hex(data: ByteArray): String {
        val hexChars = "0123456789abcdef".toCharArray()
        val r = StringBuilder(data.size * 2)
        data.forEach { b ->
            val i = b.toInt()
            r.append(hexChars[i shr 4 and 0xF])
            r.append(hexChars[i and 0xF])
        }
        return r.toString()
    }
}