package com.cloud.baobabsland.utils

import com.cloud.baobabsland.worker.UnionWorker
import com.transsion.core.CoreUtil
import com.transsion.core.utils.SharedPreferencesUtil

object PreferencesHelper {
    /**  需要操作的文件名 。*/
    private const val spName = "baobab_sdk"

    /**  过得SharedPreferencesUtils实例 。*/
    @JvmStatic
    val instance: SharedPreferencesUtil
        get() = SharedPreferencesUtil.getInstance(spName)

    /**
     * 保存更新的日期
     */
    @JvmStatic
    fun saveUpdateDay(judgeKey: String, date: Int) {
        val result = instance.getString(judgeKey, "")
        if (result.isNullOrBlank()) {
            AdLogUtil.Log()
                .i(CommonLogUtil.TAG, "saveUpdateDay --> result is nullOrBlank, data = $date")
            instance.putString(judgeKey, "$date-1")
        } else {
            val resultSplit = result.split("-")
            if (date.toString() != resultSplit[0]) {
                AdLogUtil.Log()
                    .i(CommonLogUtil.TAG, "saveUpdateDay --> data isn't same, data = $date")
                instance.putString(judgeKey, "$date-1")
            } else {
                var nummber = resultSplit[1].toInt()
                instance.putString(judgeKey, "$date-${++nummber}")
                AdLogUtil.Log()
                    .i(CommonLogUtil.TAG, "saveUpdateDay -->  data = $date , nummber = $nummber")
            }
        }

    }

    /**
     * 当天是否更新过数据
     */
    @JvmStatic
    fun isUpdateData(judgeKey: String, date: Int): Boolean {

        //每天请求最高上限
        var dailyRequestMax = 3
        val unionCache = UnionWorker.getInstance(CoreUtil.getContext(), null).unionCache
        if (unionCache?.configDTO != null && unionCache.configDTO?.basicJson != null) {
            dailyRequestMax = unionCache.configDTO?.basicJson?.dailyRequestMax ?: dailyRequestMax
        }

        val result = instance.getString(judgeKey, "")
        return if (result.isNullOrBlank()) {
            AdLogUtil.Log().i(CommonLogUtil.TAG, "isUpdateData data is nullOrBlank")
            true
        } else {
            val resultSplit = result.split("-")
            if (date.toString() != resultSplit[0]) {
                true
            } else {
                val number = resultSplit[1].toInt()
                AdLogUtil.Log().i(CommonLogUtil.TAG, "isUpdateData number = $number")
                number < dailyRequestMax
            }
        }

    }
}