package com.cloud.baobabsland.utils;

import android.text.TextUtils;
import android.util.Log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * 压缩文件工具类
 */
public class ZipUtil {
    public static final String TAG = "ZIP";

    /**
     * 解压zip到指定的路径
     *
     * @param zipFileString ZIP的路径
     * @param outPathString 要解压缩路径
     * @throws Exception
     */
    public static synchronized boolean decompressZipFolder(String zipFileString, String outPathString) {
        if (TextUtils.isEmpty(zipFileString) || TextUtils.isEmpty(outPathString)) {
            return false;
        }
        String temporaryPath = outPathString + System.currentTimeMillis();
        ZipInputStream inZip = null;
        try {
            inZip = new ZipInputStream(new FileInputStream(zipFileString));
            ZipEntry zipEntry;
            while ((zipEntry = inZip.getNextEntry()) != null) {
                String szName = zipEntry.getName();
                if (TextUtils.isEmpty(szName) || szName.contains("../")) {
                    return false;
                }
                String canonicalPath;
                if (zipEntry.isDirectory()) {
                    AdLogUtil.Log().d(TAG, "directory name === " + temporaryPath + File.separator + szName);
                    File folder = new File(temporaryPath + File.separator + szName);
                    canonicalPath = folder.getCanonicalPath();
                    if (TextUtils.isEmpty(canonicalPath) || canonicalPath.contains("../")) {
                        continue;
                    }
                    folder.mkdirs();
                } else {
                    File file = new File(temporaryPath + File.separator + szName);
                    canonicalPath = file.getCanonicalPath();
                    if (TextUtils.isEmpty(canonicalPath) || canonicalPath.contains("../")) {
                        continue;
                    }
                    if (!file.exists()) {
                        AdLogUtil.Log().d(TAG, "Create the file:" + temporaryPath + File.separator + szName);
                        file.getParentFile().mkdirs();
                        if (!file.createNewFile()) {
                            AdLogUtil.Log().e("decompressZipFolder() -> createNewFile is fail!!");
                        }
                    }
                    // 获取文件的输出流
                    try (FileOutputStream out = new FileOutputStream(file)) {
                        int len;
                        byte[] buffer = new byte[1024];
                        // 读取（字节）字节到缓冲区
                        while ((len = inZip.read(buffer)) != -1) {
                            // 从缓冲区（0）位置写入（字节）字节
                            out.write(buffer, 0, len);
                            out.flush();
                        }
                    } catch (Exception e) {
                        AdLogUtil.Log().e(Log.getStackTraceString(e));
                    }
                }
            }
            File temporaryFile = new File(temporaryPath);
            File outFile = new File(outPathString);
            if (temporaryFile.exists() && !temporaryFile.renameTo(outFile)) {
                AdLogUtil.Log().e("decompressZipFolder() -> renameTo handle is fail!!");
            }
        } catch (IOException e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
            return false;
        } finally {
            if (inZip != null) {
                try {
                    inZip.close();
                } catch (IOException e) {
                    AdLogUtil.Log().e(Log.getStackTraceString(e));
                }
            }
        }
        return true;
    }
}
