package com.cloud.baobabsland.webview

import android.content.Context
import android.content.res.Resources
import android.net.ConnectivityManager
import android.os.Build
import java.util.*

/**
 *
 * map工具类
 */
object CollectionUtil {
    fun isNetworkConnected(context: Context?): Boolean {
        if (context != null) {
            val mConnectivityManager = context
                .getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
            val mNetworkInfo = mConnectivityManager.activeNetworkInfo
            if (mNetworkInfo != null) {
                return mNetworkInfo.isAvailable
            }
        }
        return false
    }

    fun getLanguage(resources: Resources):String {
        val locale: Locale?
        locale = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            resources.configuration.locales[0]
        } else {
            resources.configuration.locale
        }
        return locale.language
    }
}