package com.cloud.baobabsland.webview

import com.cloud.baobabsland.webview.view.WebViewLayout

internal interface WebViewAction {

    fun getStatusLayout(): WebViewLayout?
    fun showComplete() {
        val layout = getStatusLayout()
        if (layout == null || !layout.isShow()) {
            return
        }
        layout.hide()
    }

    fun showError(listener: WebViewLayout.OnReloadListener) {
        val layout = getStatusLayout()
        layout?.show()
        layout?.setOnReloadListener(listener)
    }
}