/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.baobabsland.athena;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.baobabsland.UnionSetting;
import com.cloud.baobabsland.athena.AthenaUtil;
import com.cloud.baobabsland.utils.AdLogUtil;
import com.cloud.baobabsland.utils.CommonUtils;
import com.cloud.baobabsland.utils.PreferencesHelper;
import com.cloud.baobabsland.worker.UnionWorker;
import com.google.gson.JsonObject;
import com.transsion.athenacust.AthenaCust;
import com.transsion.core.CoreUtil;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.ga.AthenaAnalytics;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\nJ\b\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\fH\u0007J<\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001d\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\fH\u0007J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\fH\u0007J(\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0007J\u0012\u0010*\u001a\u00020\b2\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010,\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\nH\u0007J$\u0010.\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010/\u001a\u00020\fH\u0007J\u001c\u00100\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0002J\u0012\u00104\u001a\u00020\b2\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0007J\u000e\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\fJ\u000e\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020\b2\u0006\u0010!\u001a\u00020\fH\u0007J\u000e\u0010<\u001a\u00020\b2\u0006\u00109\u001a\u00020:R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/cloud/baobabsland/athena/AthenaTracker;", "", "()V", "REQUEST_TIME", "", "handler", "Landroid/os/Handler;", "deleteLocalData", "", "openCache", "", "deleteResult", "", "getCommonBundle", "Landroid/os/Bundle;", "initAthena", "context", "Landroid/content/Context;", "isDebug", "initHandler", "mediaLoadType", "loadType", "trackByOfflineDataRes", "eventName", "responseNum", "isSuccess", "code", "message", "recExpId", "trackByOfflineFeedReq", "channelId", "feedCode", "trackCloseNetTip", "tipsType", "trackData", "jsonObject", "trackDataByConfigReq", "requestType", "trackDataByConfigResponse", "interval", "maxExpiredTime", "offlineFeedNum", "trackDataByDownLoadZip", "downloadUrl", "trackDataByDownLoadZipRes", "checkMd5", "trackDataByDownloadPic", "downloadResult", "trackDataForHtml", "trackInNewThread", "runnable", "Ljava/lang/Runnable;", "trackInitGslb", "url", "trackInitSdk", "status", "trackLoadUrlBefore", "startTime", "", "trackShowNetTip", "trackWebViewLoadFinish", "baobabsland-sdk_release"})
public final class AthenaTracker {
    @NotNull
    public static final AthenaTracker INSTANCE = new AthenaTracker();
    @Nullable
    private static Handler handler;
    @NotNull
    private static final String REQUEST_TIME = "request_time";

    private AthenaTracker() {
    }

    private final synchronized void initHandler() {
        if (handler == null) {
            AthenaUtil.Companion companion = AthenaUtil.Companion;
            AthenaTracker athenaTracker = companion.getInstance();
            companion.start();
            handler = new Handler(athenaTracker.getLooper());
            AdLogUtil.Log().d("baobab", "AthenaTracker initHandlerThread");
        }
    }

    private final void trackInNewThread(Runnable runnable) {
        athenaTracker.initHandler();
        AthenaTracker athenaTracker = handler;
        if (athenaTracker != null) {
            athenaTracker.post(runnable);
        }
    }

    private final Bundle getCommonBundle() {
        Bundle bundle;
        AthenaTracker athenaTracker = bundle;
        bundle = new Bundle();
        String string = "";
        Object object = CoreUtil.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext()");
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        UnionWorker.b.b.b = object;
        object = UnionWorker.b.b.c;
        if (object != null) {
            string = String.valueOf(object != null ? ((UnionSetting)object).getAppId() : null);
        }
        AthenaTracker athenaTracker2 = athenaTracker;
        athenaTracker2.putString("appid", string);
        athenaTracker2.putString("vaid", CommonUtils.getVAID());
        athenaTracker2.putString("gaid", CommonUtils.getGAID());
        athenaTracker2.putString("udid", CommonUtils.getUDID());
        athenaTracker2.putInt("udidType", PreferencesHelper.getInstance().getInt("union_udid_type"));
        athenaTracker2.putString("union_package_name", CoreUtil.getContext().getPackageName());
        athenaTracker2.putString("union_version", "1.0.3.0");
        athenaTracker2.putString("country", CommonUtils.getCountry());
        athenaTracker2.putString("language", CommonUtils.getSystemLanguage());
        long l = System.currentTimeMillis();
        athenaTracker2.putLong("sdk_ts", l);
        athenaTracker2.putInt("is_offline", CommonUtils.checkNetworkState() ? 1 : 0);
        return athenaTracker2;
    }

    @JvmStatic
    public static final void trackDataForHtml(@Nullable String string, @Nullable String string2) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackDataForHtml$lambda-1(string, string2));
    }

    private final void trackData(String string, String string2) {
        this.trackInNewThread(() -> AthenaTracker.trackData$lambda-2(string, string2));
    }

    @JvmStatic
    public static final void trackInitGslb(@Nullable String string) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        new JsonObject().addProperty("gslb_url", string);
        string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("gslb_init", string);
    }

    @JvmStatic
    public static final void trackDataByConfigReq(int n) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackDataByConfigReq$lambda-3(n));
    }

    @JvmStatic
    public static final void trackDataByConfigResponse(boolean bl, int n, int n2, int n3) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackDataByConfigResponse$lambda-4(bl, n, n2, n3));
    }

    @JvmStatic
    public static final void trackDataByDownLoadZip(@Nullable String string) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackDataByDownLoadZip$lambda-5(string));
    }

    @JvmStatic
    public static final void trackDataByDownLoadZipRes(int n, @Nullable String string, boolean bl) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackDataByDownLoadZipRes$lambda-6(n, string, bl));
    }

    @JvmStatic
    public static final void trackDataByDownloadPic(@Nullable String string, @Nullable String string2, int n) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackDataByDownloadPic$lambda-7(string, string2, n));
    }

    @JvmStatic
    public static final void mediaLoadType(int n) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.mediaLoadType$lambda-9(n));
    }

    @JvmStatic
    public static final void trackByOfflineFeedReq(int n, @Nullable String string) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackByOfflineFeedReq$lambda-10(n, string));
    }

    @JvmStatic
    public static final void trackByOfflineFeedReq(@Nullable String string) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackByOfflineFeedReq$lambda-11(string));
    }

    @JvmStatic
    public static final void trackByOfflineDataRes(@NotNull String string, int n, int n2, int n3, @Nullable String string2, @Nullable String string3) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"eventName");
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackByOfflineDataRes$lambda-12(n, n2, n3, string2, string3, string));
    }

    @JvmStatic
    public static final void trackShowNetTip(int n) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackShowNetTip$lambda-13(n));
    }

    @JvmStatic
    public static final void trackCloseNetTip(int n) {
        INSTANCE.trackInNewThread(() -> AthenaTracker.trackCloseNetTip$lambda-14(n));
    }

    private static final void initAthena$lambda-0(Context object) {
        if (!TextUtils.isEmpty((CharSequence)(object = AthenaAnalytics.getAppVAID((Context)object, (boolean)true)))) {
            PreferencesHelper.getInstance().putString("union_athena_vaid", (String)object);
        }
    }

    private static final void trackDataForHtml$lambda-1(String string, String string2) {
        AdLogUtil.Log().i("Athena", "--------trackDataForHtml() -> eventName = " + string + " , jsonObject = " + string2);
        Bundle bundle = INSTANCE.getCommonBundle();
        bundle.putString("data", string2);
        new AthenaCust(string, 3058).trackCommon(bundle, null).submit();
    }

    private static final void trackData$lambda-2(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"$eventName");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"$jsonObject");
        AdLogUtil.Log().i("Athena", "--------trackData() -> eventName = " + string + " , jsonObject = " + string2);
        Bundle bundle = INSTANCE.getCommonBundle();
        bundle.putString("data", string2);
        new AthenaCust(string, 3058).trackCommon(bundle, null).submit();
    }

    private static final void trackDataByConfigReq$lambda-3(int n) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject.addProperty("request_type", (Number)n);
        jsonObject.addProperty("union_times", (Number)System.currentTimeMillis());
        String string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("config_request", string);
    }

    private static final void trackDataByConfigResponse$lambda-4(boolean bl, int n, int n2, int n3) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject2.addProperty("is_open_cache", Boolean.valueOf(bl));
        jsonObject2.addProperty("union_interval", (Number)n);
        jsonObject2.addProperty("max_expired_time", (Number)n2);
        jsonObject.addProperty("config_num", (Number)n3);
        String string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("config_request_result", string);
    }

    private static final void trackDataByDownLoadZip$lambda-5(String string) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        new JsonObject().addProperty("download_data_type", (Number)1);
        jsonObject2.addProperty("download_url", string);
        jsonObject2.addProperty(REQUEST_TIME, (Number)System.currentTimeMillis());
        string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("download_zip", string);
    }

    private static final void trackDataByDownLoadZipRes$lambda-6(int n, String string, boolean bl) {
        JsonObject jsonObject;
        JsonObject jsonObject2;
        JsonObject jsonObject3 = jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject3.addProperty("download_respones_code", (Number)n);
        jsonObject3.addProperty("download_respones_message", string);
        String string2 = "checkmd5";
        jsonObject.addProperty(string2, (Number)(bl ? 1 : 0));
        jsonObject.addProperty(REQUEST_TIME, (Number)System.currentTimeMillis());
        string2 = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.toString()");
        INSTANCE.trackData("download_zip_result", string2);
    }

    private static final void trackDataByDownloadPic$lambda-7(String string, String string2, int n) {
        JsonObject jsonObject;
        JsonObject jsonObject2;
        JsonObject jsonObject3 = jsonObject2 = jsonObject;
        jsonObject3();
        jsonObject3.addProperty("feedCode", string);
        jsonObject3.addProperty("download_url", string2);
        jsonObject.addProperty("download_result", (Number)n);
        jsonObject.addProperty(REQUEST_TIME, (Number)System.currentTimeMillis());
        string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("download_material", string);
    }

    private static final void deleteLocalData$lambda-8(boolean bl, int n) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject2.addProperty("is_open_cache", Boolean.valueOf(bl));
        jsonObject.addProperty("delete_result", (Number)n);
        jsonObject.addProperty(REQUEST_TIME, (Number)System.currentTimeMillis());
        String string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("delete_local_data", string);
    }

    private static final void mediaLoadType$lambda-9(int n) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject.addProperty("request_type", (Number)n);
        jsonObject.addProperty(REQUEST_TIME, (Number)System.currentTimeMillis());
        String string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("media_call_request", string);
    }

    private static final void trackByOfflineFeedReq$lambda-10(int n, String string) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject.addProperty("channel_id", String.valueOf(n));
        jsonObject.addProperty("rec_exp_id", string);
        String string2 = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.toString()");
        INSTANCE.trackData("offline_feed_request", string2);
    }

    private static final void trackByOfflineFeedReq$lambda-11(String string) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        new JsonObject().addProperty("feedCodes", string);
        string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("offline_detail_request", string);
    }

    private static final void trackByOfflineDataRes$lambda-12(int n, int n2, int n3, String string, String string2, String string3) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"$eventName");
        JsonObject jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject2.addProperty("response_data_num", (Number)n);
        jsonObject2.addProperty("response_state", (Number)n2);
        jsonObject.addProperty("response_code", (Number)n3);
        jsonObject.addProperty("response_message", string);
        jsonObject.addProperty("rec_exp_id", string2);
        String string4 = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"jsonObject.toString()");
        INSTANCE.trackData(string3, string4);
    }

    private static final void trackShowNetTip$lambda-13(int n) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject.addProperty("tips_type", (Number)n);
        jsonObject.addProperty("ts", (Number)System.currentTimeMillis());
        String string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("show_no_network_tips", string);
    }

    private static final void trackCloseNetTip$lambda-14(int n) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        jsonObject2();
        jsonObject.addProperty("tips_type", (Number)n);
        jsonObject.addProperty("ts", (Number)System.currentTimeMillis());
        String string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("close_no_network_tips", string);
    }

    private static final void trackWebViewLoadFinish$lambda-15(long l) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        new JsonObject().addProperty("load_time", (Number)(System.currentTimeMillis() - l));
        jsonObject2.addProperty("ts", (Number)System.currentTimeMillis());
        String string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("webview_load_finish", string);
    }

    private static final void trackLoadUrlBefore$lambda-16(long l) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject;
        new JsonObject().addProperty("load_time", (Number)(System.currentTimeMillis() - l));
        String string = jsonObject2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        INSTANCE.trackData("webview_load_url_before", string);
    }

    public final void initAthena(@Nullable Context context, boolean bl) {
        try {
            boolean bl2 = bl;
            AthenaAnalytics.init((Context)context, (String)"baobabsland", (int)3058, (boolean)bl, (boolean)false);
            AthenaAnalytics.setTest((boolean)bl2);
            AthenaAnalytics.setDebug((boolean)bl2);
            TranssionPoolManager.getInstance().addTask(() -> AthenaTracker.initAthena$lambda-0(context));
        }
        catch (Exception exception) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)exception));
        }
    }

    public final void trackInitSdk(int n) {
        AthenaTracker athenaTracker = string;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("init_status", (Number)n);
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        athenaTracker.trackData("union_sdk_init", string);
    }

    public final void deleteLocalData(boolean bl, int n) {
        this.trackInNewThread(() -> AthenaTracker.deleteLocalData$lambda-8(bl, n));
    }

    public final void trackWebViewLoadFinish(long l) {
        this.trackInNewThread(() -> AthenaTracker.trackWebViewLoadFinish$lambda-15(l));
    }

    public final void trackLoadUrlBefore(long l) {
        this.trackInNewThread(() -> AthenaTracker.trackLoadUrlBefore$lambda-16(l));
    }
}

