/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.baobabsland.http.listener;

import android.os.Handler;
import android.os.Looper;
import com.cloud.baobabsland.constant.ErrorCode;

public abstract class ResponseBaseListener {
    public Handler handler;

    public ResponseBaseListener() {
        this(Looper.myLooper());
    }

    private ResponseBaseListener(Looper looper) {
        if (looper != null) {
            ResponderHandler responderHandler;
            ResponderHandler responderHandler2 = responderHandler;
            responderHandler = new ResponderHandler(looper);
            this.handler = responderHandler2;
        } else {
            this.handler = null;
        }
    }

    public void onServerRequestFailure(int n, String string, Throwable throwable) {
        this.onServerRequestFailure(new ErrorCode(n, "error msg = " + string));
    }

    public void onServerRequestFailure(int n, byte[] byArray, Throwable throwable) {
        this.onServerRequestFailure(new ErrorCode(n, "error msg = " + byArray));
    }

    public void onServerRequestFailure(ErrorCode errorCode) {
        Handler handler = this.handler;
        if (handler != null) {
            handler.post(() -> this.onRequestError(errorCode));
        } else {
            this.onRequestError(errorCode);
        }
    }

    public abstract void onRequestError(ErrorCode var1);

    public class ResponderHandler
    extends Handler {
        public ResponderHandler(Looper looper) {
            super(looper);
        }
    }
}

