/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.baobabsland.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.cloud.baobabsland.utils.AdLogUtil;
import com.cloud.baobabsland.webview.ActionWebViewClient;
import com.cloud.baobabsland.webview.CollectionUtil;
import com.cloud.baobabsland.webview.CoreJsBridge;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0003J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/cloud/baobabsland/webview/ActionWebView;", "Landroid/webkit/WebView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "destroy", "", "init", "setOverScrollMode", "mode", "", "Companion", "baobabsland-sdk_release"})
public class ActionWebView
extends WebView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static final String CACHE_PATCH = "/web";
    @Nullable
    private static final String USERAGENT_AGENTWEB = " Web ";
    @Nullable
    private static final String USERAGENT_UC = " UCBrowser/11.6.4.950 ";
    @Nullable
    private static WebViewClient sWebViewClient;
    private static boolean sIfDebug;
    @Nullable
    private static CoreJsBridge sCoreJsBridge;
    @Nullable
    private static String sJsName;

    public ActionWebView(@NotNull Context context) {
        ActionWebView actionWebView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        actionWebView.init();
    }

    @SuppressLint(value={"JavascriptInterface"})
    public ActionWebView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        ActionWebView actionWebView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attrs");
        super(context, attributeSet);
        actionWebView.init();
    }

    @SuppressLint(value={"JavascriptInterface"})
    private final void init() {
        WebView.setWebContentsDebuggingEnabled((boolean)sIfDebug);
        Object object = this.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settings");
        object.setUserAgentString(object.getUserAgentString() + USERAGENT_AGENTWEB + USERAGENT_UC);
        object.setJavaScriptEnabled(true);
        object.setSupportZoom(true);
        object.setBuiltInZoomControls(false);
        object.setSavePassword(false);
        if (CollectionUtil.INSTANCE.isNetworkConnected(this.getContext())) {
            object.setCacheMode(-1);
        } else {
            object.setCacheMode(1);
        }
        int n = Build.VERSION.SDK_INT;
        if (n >= 21) {
            object.setMixedContentMode(0);
            this.setLayerType(2, null);
        } else if (n >= 19) {
            this.setLayerType(2, null);
        } else if (n < 19) {
            this.setLayerType(1, null);
        }
        WebSettings webSettings = object;
        webSettings.setTextZoom(100);
        webSettings.setDatabaseEnabled(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setSupportMultipleWindows(false);
        webSettings.setBlockNetworkImage(false);
        webSettings.setAllowFileAccess(true);
        if (n >= 16) {
            WebSettings webSettings2 = object;
            webSettings2.setAllowFileAccessFromFileURLs(false);
            webSettings2.setAllowUniversalAccessFromFileURLs(false);
        }
        object.setJavaScriptCanOpenWindowsAutomatically(true);
        if (n >= 19) {
            object.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        } else {
            object.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        WebSettings webSettings3 = object;
        webSettings3.setDomStorageEnabled(true);
        webSettings3.setNeedInitialFocus(true);
        webSettings3.setDefaultTextEncodingName("utf-8");
        webSettings3.setDefaultFontSize(16);
        webSettings3.setMinimumFontSize(12);
        webSettings3.setGeolocationEnabled(true);
        String string = Companion.getCachePath(this.getContext());
        webSettings3.setGeolocationDatabasePath(string);
        webSettings3.setDatabasePath(string);
        webSettings3.setAppCachePath(string);
        webSettings3.setAppCacheMaxSize(Long.MAX_VALUE);
        webSettings3.setJavaScriptEnabled(true);
        if (n >= 21) {
            object.setMixedContentMode(0);
        }
        WebSettings webSettings4 = object;
        webSettings4.setUseWideViewPort(true);
        webSettings4.setLoadWithOverviewMode(true);
        if (sCoreJsBridge != null && !TextUtils.isEmpty((CharSequence)sJsName)) {
            object = sCoreJsBridge;
            Intrinsics.checkNotNull((Object)object);
            string = sJsName;
            Intrinsics.checkNotNull((Object)string);
            this.addJavascriptInterface(object, string);
        }
        if ((object = sWebViewClient) != null) {
            Intrinsics.checkNotNull((Object)object);
            this.setWebViewClient((WebViewClient)object);
        } else {
            this.setWebViewClient(new ActionWebViewClient(this.getContext()));
        }
    }

    @JvmStatic
    public static final void setDebug(boolean bl) {
        Companion.setDebug(bl);
    }

    @JvmStatic
    public static final void setClient(@Nullable WebViewClient webViewClient) {
        Companion.setClient(webViewClient);
    }

    @JvmStatic
    public static final void setJsHelper(@Nullable String string, @Nullable CoreJsBridge coreJsBridge) {
        Companion.setJsHelper(string, coreJsBridge);
    }

    @JvmStatic
    @Nullable
    public static final String getCachePath(@Nullable Context context) {
        return Companion.getCachePath(context);
    }

    public void setOverScrollMode(int n) {
        try {
            super.setOverScrollMode(n);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)exception));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        ActionWebView actionWebView = this;
        sWebViewClient = null;
        Companion.setJsHelper(null, null);
        actionWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
        ViewParent viewParent = actionWebView.getParent();
        if (viewParent == null) throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        try {
            ((ViewGroup)viewParent).removeView((View)this);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)exception));
        }
        super.destroy();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0007J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u000eH\u0007J\u001c\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010\fH\u0007R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/cloud/baobabsland/webview/ActionWebView$Companion;", "", "()V", "CACHE_PATCH", "", "getCACHE_PATCH", "()Ljava/lang/String;", "USERAGENT_AGENTWEB", "getUSERAGENT_AGENTWEB", "USERAGENT_UC", "getUSERAGENT_UC", "sCoreJsBridge", "Lcom/cloud/baobabsland/webview/CoreJsBridge;", "sIfDebug", "", "getSIfDebug", "()Z", "setSIfDebug", "(Z)V", "sJsName", "sWebViewClient", "Landroid/webkit/WebViewClient;", "getSWebViewClient", "()Landroid/webkit/WebViewClient;", "setSWebViewClient", "(Landroid/webkit/WebViewClient;)V", "getCachePath", "context", "Landroid/content/Context;", "setClient", "", "webViewClient", "setDebug", "ifDebug", "setJsHelper", "name", "coreJsBridge", "baobabsland-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @Nullable
        public final String getCACHE_PATCH() {
            return CACHE_PATCH;
        }

        @Nullable
        public final String getUSERAGENT_AGENTWEB() {
            return USERAGENT_AGENTWEB;
        }

        @Nullable
        public final String getUSERAGENT_UC() {
            return USERAGENT_UC;
        }

        @Nullable
        public final WebViewClient getSWebViewClient() {
            return sWebViewClient;
        }

        public final void setSWebViewClient(@Nullable WebViewClient webViewClient) {
            sWebViewClient = webViewClient;
        }

        public final boolean getSIfDebug() {
            return sIfDebug;
        }

        public final void setSIfDebug(boolean bl) {
            sIfDebug = bl;
        }

        @JvmStatic
        public final void setDebug(boolean bl) {
            this.setSIfDebug(bl);
        }

        @JvmStatic
        public final void setClient(@Nullable WebViewClient webViewClient) {
            this.setSWebViewClient(webViewClient);
        }

        @JvmStatic
        public final void setJsHelper(@Nullable String string, @Nullable CoreJsBridge coreJsBridge) {
            sCoreJsBridge = coreJsBridge;
            sJsName = string;
        }

        @JvmStatic
        @Nullable
        public final String getCachePath(@Nullable Context object) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            object = object != null && (object = object.getCacheDir()) != null ? ((File)object).getAbsolutePath() : null;
            return stringBuilder2.append((String)object).append(this.getCACHE_PATCH()).toString();
        }
    }
}

