package com.cloud.baobabsland.athena

import android.os.HandlerThread

/**
 * athena上报新开一个线程
 */
class AthenaUtil {

    companion object {
        private const val THREAD_NAME = "athena track thread"

        @Volatile
        private var started = false

        val instance: HandlerThread
            get() = HandlerThreadInstance.INSTANCE

        @Synchronized
        fun start() {
            if (!started) {
                instance.start()
                started = !started
            }
        }
    }

    private object HandlerThreadInstance {
        val INSTANCE = HandlerThread(THREAD_NAME)
    }
}