package com.cloud.baobabsland.http;


import android.text.TextUtils;
import android.util.Log;

import com.cloud.baobabsland.http.listener.DrawableResponseListener;
import com.cloud.baobabsland.utils.AdLogUtil;
import com.cloud.baobabsland.utils.CommonLogUtil;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.ImageURL;
import com.transsion.http.RequestCall;
import com.transsion.http.impl.HttpCallbackImpl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


public class DownLoadRequest extends RequestBase<DrawableResponseListener> {

    public static boolean IS_HAD_AD_CHOICE = false;
    private static final int HTTP_CACHE_SUCCESS = 250;
    private static final int HTTP_CACHE_FAIL = 256;

    /***资源大小*/
    long fileSize = 0L;
    /***cdn 请求头获取*/
    String cdn = "";
    /***请求开始时间*/
    long startTime = 0L;
    /***网路请求错误代码*/
    int errorCode = -1;

    //  物料类型 1=logo 2=大图 int
    private int mType;
    /***1. 从网络获取；2. 从本地缓存获取*/
    private int requestType = 1;
    private boolean isFetch = true;
    private boolean isOffline = true;
    private boolean isUsePool = true;

    private String url = "";

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setFetch(boolean isFectch) {
        this.isFetch = isFectch;
        return this;
    }

    public DownLoadRequest setUsePool(boolean usePool) {
        isUsePool = usePool;
        return this;
    }

    /**
     * 前期执行检查网络
     */
    @Override
    public void netRequestPreExecute(Map<String, String> headers, Map<String, String> params) {
        if (TextUtils.isEmpty(url)) {
            AdLogUtil.Log().e(CommonLogUtil.TAG, "url is empty");
            return;
        }
        netRequestPosExecute(headers, params);
    }

    @Override
    protected void netRequestPosExecute(Map<String, String> headers, Map<String, String> params) {
        try {
            RequestCall requestCall = HttpClient.image(CoreUtil.getContext())
                    .log(false)
                    .cache(true)
                    .fetchFilePath(isFetch)
                    .useOffLineCache(isOffline)
                    .connectTimeout(TIMEOUT_IN_MILLIONS)
                    .readTimeout(20 * 1000)
                    .url(url)
                    .build();
            // 用于计算网络请求耗时
            startTime = System.currentTimeMillis();
            requestCall.execute(new HttpCallbackImpl(isUsePool) {
                @Override
                public void onSuccess(int statusCode, byte[] data) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "DownLoadRequest --> onSuccess statusCode = " + statusCode + " url = " + url);
                    requestType = statusCode == HTTP_CACHE_SUCCESS ? 2 : 1;
                    if (mListener != null && mListener instanceof DrawableResponseListener) {
                        mListener.onServerRequestSuccess(0, statusCode, data, null);
                    }
                    if (null != data) {
                        fileSize = data.length;
                    }
                }

                @Override
                public void onResponseHeader(Map<String, List<String>> map) {
                    super.onResponseHeader(map);
                    // 如果是客户端读取的应该是x-response-cdn
                    // 如果是服务端应该是拿x-request-cdn
                    if (null != map && !map.isEmpty()) {
                        List<String> strings = map.get("x-response-cdn");
                        if (null != strings && !strings.isEmpty()) {
                            cdn = strings.get(0);
                        }
                    }
                }

                @Override
                public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "DownLoadRequest --> onFailure statusCode " + statusCode + " e -> " + throwable + " url -> " + url);
                    requestType = statusCode == HTTP_CACHE_FAIL ? 2 : 1;
                    if (mListener != null) {
                        mListener.onServerRequestFailure(statusCode, bytes, throwable);
                    }
                    errorCode = statusCode;
                }

                @Override
                public void onSuccess(int statusCode, byte[] responseBody, final String filePath) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "DownLoadRequest --> onSuccess statusCode = " + statusCode + " , filePath = " + filePath + " , url = " + url);
                    requestType = statusCode == HTTP_CACHE_SUCCESS ? 2 : 1;
                    if (mListener != null && mListener instanceof DrawableResponseListener) {
                        mListener.onServerRequestSuccess(0, statusCode, responseBody, filePath);
                    }
                    if (null != responseBody) {
                        fileSize = responseBody.length;
                    }
                }
            });
        } catch (Throwable e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
        }
    }

    /**
     * 开始下载 下载成功 下载失败 日志上报
     * info 广告详情
     * requestType 请求方式 1. 从网络获取；2. 从本地缓存获取
     * downloadWay 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * mStatus     下载状态 1.开始下载 2.下载成功 3.下载失败
     * errorCode   错误信息
     * mType       资源类型
     * cdn         资源来源
     * timeConsuming 耗时
     * fileSize   文件大小
     */
    private void downloadTrack(int mStatus) {

    }

    /**
     * file_size 单位转换成 KB 上传
     *
     * @param byteSize byte size
     * @return
     */
    public static int getSize(long byteSize) {
        int size = 0;
        try {
            BigDecimal sizeNew = new BigDecimal(byteSize);
            size = sizeNew.divide(BigDecimal.valueOf(1024), 0, BigDecimal.ROUND_HALF_UP).intValue();
        } catch (Exception e) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, Log.getStackTraceString(e));
        }
        return size;
    }


}
