package com.cloud.baobabsland.http;

import com.cloud.baobabsland.constant.ErrorCode;
import com.cloud.baobabsland.http.listener.ResponseBaseListener;
import com.cloud.baobabsland.utils.CommonUtils;

import java.util.Map;

public abstract class RequestBase<T extends ResponseBaseListener> {

    protected final int TIMEOUT_IN_MILLIONS = 15 * 1000;
    protected T mListener = null;

    public void cancelRequest() {
        if (mListener != null) {
            mListener = null;
        }
    }

    /**
     * 前期执行检查网络
     */
    public void netRequestPreExecute(Map<String, String> headers, Map<String, String> params) {
        if (!CommonUtils.checkNetworkState()) { //断网
            if (mListener != null) {
                mListener.onServerRequestFailure(ErrorCode.NETWORK_ERROR);
            }
            return;
        }

        netRequestPosExecute(headers, params);
    }


    /**
     * 子类自身的网络请求
     */
    protected abstract void netRequestPosExecute(Map<String, String> headers, Map<String, String> params);

}
