package com.cloud.baobabsland.http;

import android.text.TextUtils;
import android.util.Log;

import com.cloud.baobabsland.constant.ErrorCode;
import com.cloud.baobabsland.constant.ServerConfig;
import com.cloud.baobabsland.http.listener.CommonResponseListener;
import com.cloud.baobabsland.http.sign.HttpSigner;
import com.cloud.baobabsland.utils.AdLogUtil;
import com.cloud.baobabsland.utils.CollectionUtils;
import com.cloud.baobabsland.utils.CommonLogUtil;
import com.cloud.baobabsland.utils.CommonUtils;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.builder.RequestBuilder;
import com.transsion.http.impl.StringCallback;

import java.util.List;
import java.util.Map;

import javax.net.ssl.SSLSocketFactory;


public class ServerRequest extends RequestBase<CommonResponseListener> {
    private String mUrl = "";
    private boolean mIsDebug = false;
    private SSLSocketFactory mSSLSocketFactory = null;
    private IPostBody mPostBody = null;

    public ServerRequest setPostBody(IPostBody postBody) {
        this.mPostBody = postBody;
        return this;
    }

    public ServerRequest setListener(CommonResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public ServerRequest setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public ServerRequest setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
        return this;
    }

    public ServerRequest setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.mSSLSocketFactory = sslSocketFactory;
        return this;
    }


    @Override
    protected void netRequestPosExecute(Map<String, String> headers, Map<String, String> params) {
        TranssionPoolManager.getInstance().addTask(() -> sendRequestToServer(headers, params));
    }

    public interface IPostBody {
        String getPostBody();
    }

    /**
     * 发起网络请求
     */
    private void sendRequestToServer(Map<String, String> headers, Map<String, String> params) {

        String postBodyString = mPostBody.getPostBody();
        if (TextUtils.isEmpty(postBodyString)) {
            if (mListener != null) {
                mListener.onServerRequestFailure(-1, "TextUtils.isEmpty(postBodyString) == true ", null);
            }
            AdLogUtil.netLog("sendRequestToServer() --> TextUtils.isEmpty(postBodyString) == true ");
        }

        try {
            if (!TextUtils.isEmpty(mUrl)) {
                if (CollectionUtils.isNotEmpty(params)) {
                    mUrl = mUrl + "?" + CollectionUtils.getUrlParamsByMap(params);
                }

                final String str = "----- full url = " + mUrl + "\n ----- postBodyString = " + postBodyString.trim();

                HttpSigner.setTest(ServerConfig.INSTANCE.getAppModule() == ServerConfig.DEV);
                AdLogUtil.Log().i(CommonLogUtil.TAG, "postBodyString = " + postBodyString
                        + " , timeZone = " + CommonUtils.getTimeZone()
                        + " , country = " + CommonUtils.getCountry()
                        + " , language = " + CommonUtils.getSystemLanguage());
                String signStr = HttpSigner.doSign("post", "", "application/json", mUrl, postBodyString);
                RequestBuilder builder = HttpClient.postJson()  //必须方法体
                        .log(mIsDebug)
                        .sslSocketFactory(mSSLSocketFactory)  //Tan 需要私有证书校验,Adx不需要
                        .content(postBodyString) //必须方法体，上传的String类型的数据文本，目前只提供上传String接口
                        .connectTimeout(TIMEOUT_IN_MILLIONS)   //网络连接超时时间
                        .readTimeout(TIMEOUT_IN_MILLIONS)      //读取数据超时时间
                        .addHeader("x-tr-signature", signStr)
                        .addHeader("Accept-Timezone", CommonUtils.getTimeZone())
                        .addHeader("Accept-Country", CommonUtils.getCountry())
                        .addHeader("Accept-Language", CommonUtils.getSystemLanguage())
                        .url(mUrl);

                if (CollectionUtils.isNotEmpty(headers)) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        builder.addHeader(entry.getKey(), entry.getValue());
                    }
                }

                builder.build()
                        .execute(new StringCallback(true) {
                                     @Override
                                     public void onSuccess(final int statusCode, String response) {
                                         AdLogUtil.netLog(str
                                                 + "\n ----- status code = " + statusCode
                                                 + "\n ----- response = " + response);

                                         if (!TextUtils.isEmpty(response)) {
                                             if (mListener != null) {
                                                 mListener.onServerRequestSuccess(statusCode, response);
                                             }
                                         } else {
                                             AdLogUtil.netLog("TextUtils.isEmpty(response) == true ,  response is null ");
                                         }
                                     }

                                     @Override
                                     public void onResponseHeader(Map<String, List<String>> map) {

                                     }

                                     @Override
                                     public void onFailure(int statusCode, String response, Throwable throwable) {
                                         boolean isNeedRetry = HttpSigner.needRetryForTimeIssue(statusCode, response);
                                         if (isNeedRetry) {
                                             sendRequestToServer(headers, params);
                                             return;
                                         }
                                         if (null != throwable) {
                                             AdLogUtil.netLog(str
                                                     + " ----- error statusCode = " + statusCode
                                                     + " ----- error message = " + throwable.getMessage()
                                                     + " ----- response = " + response
                                             );
                                         }

                                         if (mListener != null) {
                                             mListener.onServerRequestFailure(statusCode, response, throwable);
                                         }
                                     }
                                 }

                        );
            }

        } catch (Throwable e) {
            AdLogUtil.netLog("AdServerRequest --> " + Log.getStackTraceString(e));

            if (mListener != null) {
                mListener.onServerRequestFailure(new ErrorCode(ErrorCode.UNKNOWN_ERROR_CODE, e.getMessage()));
            }
        }
    }
}
