package com.cloud.baobabsland.http.listener;

import android.util.Log;

import com.cloud.baobabsland.utils.AdLogUtil;
import com.cloud.baobabsland.utils.gsonutil.GsonUtil;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class CommonResponseListener<E> extends ResponseBaseListener {

    protected CommonResponseListener() {
        super();
    }

    /**
     * 成功回调
     */
    protected abstract void onRequestSuccess(int statusCode, E response);

    public void onServerRequestSuccess(int statusCode, String response) {
        parseResponse(statusCode, response);
    }

    private void parseResponse(final int statusCode, final String responseString) {
        try {
            Type superclass = CommonResponseListener.this.getClass().getGenericSuperclass();
            if (!(superclass instanceof ParameterizedType)) {
                throw new RuntimeException("Missing type parameter.");
            }
            ParameterizedType parameterized = (ParameterizedType) superclass;
            Type type = parameterized.getActualTypeArguments()[0];


            E bean = null;
            try {
                bean = GsonUtil.fromJson(responseString, type);
            } catch (Exception e) {
                AdLogUtil.Log().i("union_log", "e: " + Log.getStackTraceString(e));
            }

            final E final_bean = bean;

            if (handler != null) {
                this.handler.post(() -> onRequestSuccess(statusCode, final_bean));
            } else {
                onRequestSuccess(statusCode, final_bean);
            }
        } catch (Throwable e) {
            AdLogUtil.netLog("CommonResponseListener --> 解析网络请求数据异常 --> parseResponse --> catch " + Log.getStackTraceString(e));
        }
    }
}
