package com.cloud.baobabsland.manager

import android.os.CountDownTimer

/**
 * 倒计时器
 */
class CountDownTimerManager(
    millisInFuture: Long,
    countDownInterval: Long
) : CountDownTimer(millisInFuture, countDownInterval) {

    private var downTimerListener: DownTimerListener? = null

    override fun onTick(millisUntilFinished: Long) {
        downTimerListener?.onTick(millisUntilFinished)
    }

    override fun onFinish() {
        downTimerListener?.onFinish()
    }

    fun setDownTimerListener(listener: DownTimerListener?) {
        this.downTimerListener = listener
    }

    interface DownTimerListener {
        fun onTick(millisUntilFinished: Long)
        fun onFinish()
    }
}