package com.cloud.baobabsland.ui

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.cloud.baobabsland.manager.ActivityAndFragmentManager.addActivity
import com.cloud.baobabsland.manager.ActivityAndFragmentManager.removeActivity
import android.os.Bundle
import com.cloud.baobabsland.R
import android.text.TextUtils
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import com.cloud.baobabsland.constant.Constants
import com.cloud.baobabsland.utils.AdLogUtil
import com.cloud.baobabsland.utils.CommonLogUtil
import com.cloud.baobabsland.worker.UnionWorker

class FeedsActivity : AppCompatActivity() {
    //跳转到detail的Url地址
    private var detailUrl: String? = ""
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.union_activity_baobab_feeds)
        if (!UnionWorker.getInstance(this, null).isInitSuccess) {
            AdLogUtil.Log().e("union sdk init is failure")
            finish()
            return
        }
        addActivity(this)
        if (intent != null) {
            detailUrl = intent.getStringExtra(Constants.KeyName.KEY_FEED_DETAIL_URL)
            if (TextUtils.isEmpty(detailUrl)) detailUrl = ""
            AdLogUtil.Log().i(CommonLogUtil.TAG, "detailUrl = $detailUrl")
        }
        replaceFragment(FeedsFragment.newInstance(detailUrl))
    }

    private fun replaceFragment(fragment: Fragment) {
        val transaction = supportFragmentManager.beginTransaction()
        transaction.replace(R.id.feed_fragment, fragment)
        transaction.commit()
    }

    override fun onDestroy() {
        super.onDestroy()
        removeActivity(this)
    }

    companion object {
        /**
         * 启动FeedActivity
         */
        fun startFeedActivity(context: Context) {
            if (UnionWorker.getInstance(context, null).isInitSuccess){
                val intent = Intent(context, FeedsActivity::class.java)
                if (context !is Activity) {
                    intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
                }
                context.startActivity(intent)
            } else {
                AdLogUtil.Log().e("startFeedActivity -> union sdk init is failure")
            }

        }
    }
}