package com.cloud.baobabsland.ui

import android.annotation.SuppressLint
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.graphics.Bitmap
import android.net.ConnectivityManager
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.text.TextUtils
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.webkit.*
import android.widget.FrameLayout
import android.widget.ImageView
import androidx.activity.OnBackPressedCallback
import androidx.fragment.app.Fragment
import androidx.webkit.WebViewAssetLoader
import androidx.webkit.WebViewAssetLoader.PathHandler
import com.cloud.baobabsland.BuildConfig
import com.cloud.baobabsland.R
import com.cloud.baobabsland.athena.AthenaTracker
import com.cloud.baobabsland.bean.response.ConfigDTO
import com.cloud.baobabsland.bean.response.FeedDetailVO
import com.cloud.baobabsland.bean.response.FeedVO
import com.cloud.baobabsland.constant.Constants
import com.cloud.baobabsland.constant.ServerConfig.h5Host
import com.cloud.baobabsland.constant.ServerConfig.h5Url
import com.cloud.baobabsland.manager.ActivityAndFragmentManager
import com.cloud.baobabsland.manager.CountDownTimerManager
import com.cloud.baobabsland.manager.CountDownTimerManager.DownTimerListener
import com.cloud.baobabsland.utils.*
import com.cloud.baobabsland.webview.ActionWebView
import com.cloud.baobabsland.webview.CoreJsBridge
import com.cloud.baobabsland.webview.WebViewAction
import com.cloud.baobabsland.webview.WebViewManager
import com.cloud.baobabsland.webview.view.WebViewLayout
import com.cloud.baobabsland.webview.view.WebViewProgress
import com.cloud.baobabsland.worker.UnionWorker
import com.cloud.baobabsland.worker.WorkerHelper.getFeedDetailVOList
import com.google.gson.Gson
import com.transsion.core.CoreUtil
import java.io.File
import java.io.FileInputStream
import java.lang.ref.WeakReference
import java.util.*

class FeedsFragment : Fragment(), WebViewAction {
    private var webView: ActionWebView? = null
    private val indexPage = "index.html"
    private var detailUrl = ""

    var startTime = 0L

    //webView拦截的url记录
    private var tempShouldInterceptUrl = ""
    private var netBroadcastReceiver: NetBroadcastReceiver? = null
    private var netCountDownTimer: CountDownTimerManager? = null
    private var noNetGroup: View? = null
    private var closeNoNetIv: ImageView? = null
    private var webViewGroup: WebViewLayout? = null
    private var webViewProgress: WebViewProgress? = null

    override fun onAttach(context: Context) {
        super.onAttach(context)
        startTime = System.currentTimeMillis()
        if (arguments != null) {
            detailUrl = requireArguments().getString(Constants.KeyName.KEY_FEED_DETAIL_URL, "")
        }

        //获取Activity的返回键分发器添加回调
        requireActivity().onBackPressedDispatcher.addCallback(
            this,
            onBackPressedCallback
        )
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ActivityAndFragmentManager.addFragment(this)
        if (requireActivity() is FeedsActivity) {
            ActivityAndFragmentManager.setMarkValue(true)
            if (TextUtils.isEmpty(detailUrl)) { //以activity的方式启动feed列表页
                AthenaTracker.mediaLoadType(1)
            }
        } else {
            ActivityAndFragmentManager.setMarkValue(false)
            if (TextUtils.isEmpty(detailUrl)) { //单独以fragment的方式启动feed列表页
                AthenaTracker.mediaLoadType(2)
            }
        }
        val filter = IntentFilter()
        filter.addAction(ConnectivityManager.CONNECTIVITY_ACTION)
        netBroadcastReceiver = NetBroadcastReceiver(this)
        requireContext().registerReceiver(netBroadcastReceiver, filter)
        netCountDownTimer = CountDownTimerManager(3000, 1000)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.union_fragment_baobab_feeds, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        noNetGroup = view.findViewById(R.id.noNetGroup)
        closeNoNetIv = view.findViewById(R.id.closeTips)
        webViewGroup = view.findViewById(R.id.webViewGroup)
        webViewProgress = view.findViewById(R.id.webViewProgress)
        initWebView(view)
    }

    override fun onDestroy() {
        ActivityAndFragmentManager.removeFragment(this)
        if (webView != null) {
            webView?.stopLoading()
            // 退出时调用此方法，移除绑定的服务，否则某些特定系统会报错
            webView?.settings?.javaScriptEnabled = false
            // 取消监听引用
            webView?.webChromeClient = null
            webView?.loadUrl("about:blank")
            webView?.clearHistory()
            webView?.removeAllViews()
            try {
                webView?.removeJavascriptInterface(jsName)
                webView?.destroy()
            } catch (e: Exception) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, Log.getStackTraceString(e))
            }
        }
        if (netBroadcastReceiver != null) {
            requireContext().unregisterReceiver(netBroadcastReceiver)
        }
        if (netCountDownTimer != null) {
            netCountDownTimer?.cancel()
        }
        super.onDestroy()
    }

    //定义返回的回调
    private val onBackPressedCallback = object : OnBackPressedCallback(true) {
        override fun handleOnBackPressed() {
            try {
                if (webView?.canGoBack() == true) {
                    webView?.goBack()
                } else {
                    requireActivity().finish()
                }
            } catch (e: Exception) {
                AdLogUtil.Log().e(Log.getStackTraceString(e))
            }

        }
    }

    @SuppressLint("SetJavaScriptEnabled")
    private fun initWebView(view: View?) {
        if (view == null) return
        try {
            val webViewLayout = view.findViewById<FrameLayout>(R.id.wv_webView)
            webView = WebViewManager.obtain(requireContext())
            webViewLayout.addView(webView)
        } catch (e: Exception) {
            AdLogUtil.Log().e(Log.getStackTraceString(e))
            try {
                requireActivity().finish()
            } catch (e1: Exception) {
                AdLogUtil.Log().e(Log.getStackTraceString(e1))
            }
        }
        if (webView == null) return
        try {
            setJsHelper()
        } catch (e: Exception) {
            AdLogUtil.Log().e(Log.getStackTraceString(e))
        }
        if (!UnionWorker.getInstance(CoreUtil.getContext(), null).isInitSuccess) {
            webView?.loadUrl("about:blank")
            return
        }
        val webSetting = webView?.settings
        webSetting?.javaScriptEnabled = true
        //设置编码格式
        webSetting?.defaultTextEncodingName = Constants.CommonConstant.ENCODING_UTF
        //当webView调用requestFocus时为webView设置节点
        webSetting?.setNeedInitialFocus(true)
        //隐藏原生的缩放控件
        webSetting?.displayZoomControls = false
        //适配移动端的页面
        webSetting?.useWideViewPort = true
        webSetting?.domStorageEnabled = true
        // Keeping these off is less critical but still a good idea, especially if your app is not
        // using file:// or content:// URLs.
        webSetting?.allowFileAccess = true
        webSetting?.allowContentAccess = true

        webView?.isVerticalScrollBarEnabled = false
        webView?.isHorizontalScrollBarEnabled = false

        webView?.webViewClient = CustomWebViewClient()
        webView?.webChromeClient = CustomWebChromeClient()

        AdLogUtil.Log().i(
            CommonLogUtil.TAG,
            "init webView time is : ${System.currentTimeMillis() - startTime}"
        )
        AthenaTracker.trackLoadUrlBefore(startTime)
        loadUrl()
    }

    inner class CustomWebChromeClient : WebChromeClient() {
        override fun onJsAlert(
            view: WebView,
            url: String,
            message: String,
            result: JsResult
        ): Boolean {
            return super.onJsAlert(view, url, message, result)
        }

        override fun onProgressChanged(view: WebView?, newProgress: Int) {
            super.onProgressChanged(view, newProgress)
            if (h5Url == view?.url || view?.url?.contains(Constants.H5Address.OFFLINE_LOAD_PAGE) == true) {
                webViewProgress?.setProgress(newProgress)
            }
        }
    }

    inner class CustomWebViewClient : WebViewClient() {
        private val indexPathSeparator = (FileUtil.getAppFilePath(CoreUtil.getContext())
                + File.separator + Constants.DownPath.OFFLINE_FOLDER_NAME
                + File.separator)
        private val indexPath = (FileUtil.getAppFilePath(CoreUtil.getContext())
                + File.separator + Constants.DownPath.OFFLINE_FOLDER_NAME)

        private val assetLoader = WebViewAssetLoader.Builder()
            .setDomain(Constants.HOST.OFFLINE_DOMAIN)
            .setHttpAllowed(true)
            .addPathHandler(
                indexPathSeparator + Constants.DownPath.H5_ZIP_FOLDER_NAME + File.separator,
                SdcardStoragePathHandler()
            )
            .addPathHandler(
                indexPathSeparator + Constants.DownPath.H5_ZIP_FOLDER_NAME + "/static/",
                SdcardStoragePathHandler()
            )
            .addPathHandler(
                indexPathSeparator + Constants.DownPath.FEED_DETAIL_IMAGE_NAME + File.separator,
                SdcardStoragePathHandler()
            )
            .addPathHandler(
                indexPathSeparator + Constants.DownPath.FEED_LIST_IMAGE_NAME + File.separator,
                SdcardStoragePathHandler()
            )
            .build()

        override fun shouldInterceptRequest(
            webView: WebView,
            request: WebResourceRequest
        ): WebResourceResponse? {
            AdLogUtil.Log()
                .i(CommonLogUtil.TAG, " network status --> " + CommonUtils.checkNetworkState())
            if (!CommonUtils.checkNetworkState() && Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                var url = request.url.toString()
                AdLogUtil.Log().i(CommonLogUtil.TAG, "before url = $url")
                if (url.lowercase(Locale.ROOT).contains(".png") || url.lowercase(Locale.ROOT)
                        .contains(".jpg")
                ) {
                    url = Constants.HOST.OFFLINE_ADDRESS + indexPath + request.url.path
                } else if (url.contains(Constants.H5Address.DETAIL_PAGE)) { //详情页处理
                    val detailPath = url.substring(url.indexOf(Constants.H5Address.DETAIL_PAGE))
                    url =
                        Constants.HOST.OFFLINE_ADDRESS + indexPathSeparator + Constants.DownPath.H5_ZIP_FOLDER_NAME + "/index.html/" + detailPath
                } else if (url.contains(Constants.H5Address.MEDIA_PAGE)) { //视频页面处理
                    val mediaPath = url.substring(url.indexOf(Constants.H5Address.MEDIA_PAGE))
                    url =
                        Constants.HOST.OFFLINE_ADDRESS + indexPathSeparator + Constants.DownPath.H5_ZIP_FOLDER_NAME + "/index.html/" + mediaPath
                } else if (!url.contains(".html")) {
                    url =
                        Constants.HOST.OFFLINE_ADDRESS + indexPathSeparator + Constants.DownPath.H5_ZIP_FOLDER_NAME + request.url.path
                }
                tempShouldInterceptUrl = url
                AdLogUtil.Log().i(CommonLogUtil.TAG, "after  url = $url")
                return assetLoader.shouldInterceptRequest(Uri.parse(url))
            }
            return super.shouldInterceptRequest(webView, request)
        }

        override fun onPageStarted(view: WebView?, url: String?, favicon: Bitmap?) {
            super.onPageStarted(view, url, favicon)
            if (h5Url == url || url?.contains(Constants.H5Address.OFFLINE_LOAD_PAGE) == true) {
                webViewProgress?.show()
            }
        }

        override fun onPageFinished(view: WebView?, url: String?) {
            showComplete()
            if (h5Url == url || url?.contains(Constants.H5Address.OFFLINE_LOAD_PAGE) == true) {
                webViewProgress?.hide()
            }
        }

        override fun onReceivedError(
            view: WebView?,
            errorCode: Int,
            description: String?,
            failingUrl: String?
        ) {
            super.onReceivedError(view, errorCode, description, failingUrl)
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                return
            }
            ThreadUtils.runOnUiThreadDelayed({
                showError(object : WebViewLayout.OnReloadListener {
                    override fun onReload(layout: WebViewLayout) {
                        webView?.reload()
                    }

                })
            }, 200)
        }

        override fun onReceivedError(
            view: WebView?,
            request: WebResourceRequest?,
            error: WebResourceError?
        ) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && request?.isForMainFrame == true) {
                ThreadUtils.runOnUiThreadDelayed({
                    showError(object : WebViewLayout.OnReloadListener {
                        override fun onReload(layout: WebViewLayout) {
                            webView?.reload()
                        }

                    })
                }, 200)
            }
        }
    }

    inner class SdcardStoragePathHandler : PathHandler {
        override fun handle(filePath: String): WebResourceResponse? {
            val indexPath = (FileUtil.getAppFilePath(CoreUtil.getContext())
                    + File.separator + Constants.DownPath.OFFLINE_FOLDER_NAME
                    + File.separator + Constants.DownPath.H5_ZIP_FOLDER_NAME + File.separator)
            AdLogUtil.Log()
                .i(CommonLogUtil.TAG, "SdcardStoragePathHandler --> filePath = $filePath")
            val extension = MimeTypeMap.getFileExtensionFromUrl(filePath)
            var mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension)
            if (mimeType == null && "js" == extension) {
                mimeType = "application/javascript"
            }

            //图片处理
            return if (extension != null && (extension.lowercase(Locale.ROOT) == "jpg" || extension.lowercase(
                    Locale.ROOT
                ) == "png")
            ) {
                handlePic(indexPath, mimeType, filePath)
            } else {
                try {
                    WebResourceResponse(
                        mimeType,
                        Constants.CommonConstant.ENCODING_UTF,
                        FileInputStream(indexPath + filePath)
                    )
                } catch (e: Exception) {
                    null
                }
            }
        }
    }

    /** 处理图片 */
    private fun handlePic(
        indexPath: String,
        mimeType: String?,
        filePath: String
    ): WebResourceResponse? {
        val picPathSeparator =
            if (!TextUtils.isEmpty(tempShouldInterceptUrl) && tempShouldInterceptUrl.contains(
                    "/feed/img/"
                )
            ) {
                (FileUtil.getAppFilePath(CoreUtil.getContext())
                        + File.separator + Constants.DownPath.OFFLINE_FOLDER_NAME
                        + File.separator + Constants.DownPath.FEED_LIST_IMAGE_NAME + File.separator)
            } else if (!TextUtils.isEmpty(tempShouldInterceptUrl) && tempShouldInterceptUrl.contains(
                    "/content/img/"
                )
            ) {
                (FileUtil.getAppFilePath(CoreUtil.getContext())
                        + File.separator + Constants.DownPath.OFFLINE_FOLDER_NAME
                        + File.separator + Constants.DownPath.FEED_DETAIL_IMAGE_NAME + File.separator)
            } else {
                indexPath
            }
        return try {
            WebResourceResponse(
                mimeType,
                Constants.CommonConstant.ENCODING_UTF,
                FileInputStream(picPathSeparator + filePath)
            )
        } catch (e: Exception) {
            null
        }
    }

    /**
     * 加载url处理
     */
    private fun loadUrl() {
        if (webView == null) return
        try {
            val isAvailable = CommonUtils.checkNetworkState()
            if (isAvailable) { //有网
                loadUrlByOnline()
            } else {
                loadUrlByOffline()
            }
        } catch (e: Exception) {
            AdLogUtil.Log().e(Log.getStackTraceString(e))
        }
    }

    /** 有网加载url 。 */
    private fun loadUrlByOnline() {
        AdLogUtil.Log().i(CommonLogUtil.TAG, "load url = $h5Url")
        showComplete()
        if (!TextUtils.isEmpty(detailUrl)) {
            //appassets.androidplatform.net 替换成 h5在线地址
            if (detailUrl.contains(Constants.HOST.OFFLINE_DOMAIN)) {
                detailUrl = detailUrl.replace(Constants.HOST.OFFLINE_DOMAIN, h5Host)
            }
            webView?.loadUrl(detailUrl)
        } else {
            webView?.loadUrl(h5Url)
        }
    }

    /** 无网加载url */
    private fun loadUrlByOffline() {
        if (TextUtils.isEmpty(detailUrl)) { //跳转到首页
            val indexPath = (FileUtil.getAppFilePath(CoreUtil.getContext())
                    + File.separator + Constants.DownPath.OFFLINE_FOLDER_NAME
                    + File.separator + Constants.DownPath.H5_ZIP_FOLDER_NAME + File.separator + indexPage)
            val file = File(indexPath)
            AdLogUtil.Log()
                .i(CommonLogUtil.TAG, "feedsFragment -> indexPath = $indexPath")
            if (file.exists()) {
                showComplete()
                webView?.loadUrl(Constants.HOST.OFFLINE_ADDRESS + indexPath)
            } else {
                showError(object : WebViewLayout.OnReloadListener {
                    override fun onReload(layout: WebViewLayout) {
                        loadUrl()
                    }
                })
                AdLogUtil.Log().i(CommonLogUtil.TAG, "load local page fail---")
            }
        } else { //跳转到详情
            webView?.loadUrl(detailUrl)
        }
    }

    /**
     * 设置js回调
     */
    private fun setJsHelper() {

        class UnionJsBridge : CoreJsBridge() {
            @JavascriptInterface
            override fun getSystemInfo(): String {
                return ""
            }

            @JavascriptInterface
            override fun goBack() {
                ThreadUtils.runOnUiThread {
                    if (webView != null && webView?.canGoBack() == true) {
                        webView?.goBack()
                    }
                }
            }

            /** 网络是否连接 。  */
            @JavascriptInterface
            fun isNetConnected(): Boolean {
                return CommonUtils.checkNetworkState()
            }

            /** 埋点数据上报 。  */
            @JavascriptInterface
            fun trackDataForHtml(eventName: String?, jsonObject: String?) {
                ThreadUtils.runOnUiThread {
                    try {
                        if (TextUtils.isEmpty(eventName) || TextUtils.isEmpty(jsonObject)) return@runOnUiThread
                        AthenaTracker.trackDataForHtml(eventName, jsonObject)
                    } catch (e: Exception) {
                        AdLogUtil.Log().e(Log.getStackTraceString(e))
                    }
                }
            }

            /** 打开新的页面  */
            @JavascriptInterface
            fun openNewWebView(url: String?) {
                if (TextUtils.isEmpty(url)) return
                ThreadUtils.runOnUiThread {
                    try {
                        val intent = Intent(requireContext(), FeedsActivity::class.java)
                        intent.putExtra(Constants.KeyName.KEY_FEED_DETAIL_URL, url)
                        intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
                        startActivity(intent)
                        AdLogUtil.Log().i(CommonLogUtil.TAG, "openNewWebView url = $url")
                    } catch (e: Exception) {
                        AdLogUtil.Log().e(Log.getStackTraceString(e))
                    }
                }
            }

            /** 关闭页面 。  */
            @JavascriptInterface
            fun closePage() {
                ThreadUtils.runOnUiThread {
                    try {
                        requireActivity().finish()
                    } catch (e: Exception) {
                        AdLogUtil.Log().e(Log.getStackTraceString(e))
                    }
                }
            }

            /** 返回首页 。  */
            @JavascriptInterface
            fun backHomePage() {
                ThreadUtils.runOnUiThread {
                    try {
                        ActivityAndFragmentManager.backHomeActivity()
                    } catch (e: Exception) {
                        AdLogUtil.Log().e(Log.getStackTraceString(e))
                    }
                }
            }

            /** 获取云控数据 。  */
            @JavascriptInterface
            fun feedConfig(): String {
                try {
                    val worker = UnionWorker.getInstance(CoreUtil.getContext(), null)
                    if (worker.unionCache != null) {
                        val configDTO = worker.unionCache?.configDTO
                        return if (configDTO != null) {
                            Gson().toJson(configDTO)
                        } else {
                            ""
                        }
                    }
                } catch (e: Exception) {
                    AdLogUtil.Log().e(Log.getStackTraceString(e))
                }
                AdLogUtil.Log().e("js feedConfig() -> data is null")
                try {
                    val configInfo = ConfigDTO()
                    configInfo.phoneModel = CommonUtils.getModel()
                    configInfo.sdkVersion = BuildConfig.SDK_VERSION
                    configInfo.sdkCode = BuildConfig.SDK_CODE.toInt()
                    val setting = UnionWorker.getInstance(CoreUtil.getContext(), null).unionSetting
                    if (setting != null) {
                        configInfo.appId = setting.appId
                    }
                    configInfo.pkgName = CoreUtil.getContext().packageName
                    configInfo.language = CommonUtils.getSystemLanguage()
                    configInfo.country = CommonUtils.getCountry()
                    configInfo.gaid = CommonUtils.getGAID()
                    configInfo.vaid = CommonUtils.getVAID()
                    configInfo.udid = CommonUtils.getUDID()
                    configInfo.udidType = PreferencesHelper.instance.getInt(Constants.KeyName.KEY_UDID_TYPE)
                    return Gson().toJson(configInfo)
                } catch (e: Exception) {
                    AdLogUtil.Log().e(Log.getStackTraceString(e))
                }
                return ""
            }

            /** 获取feedsList数据 。  */
            @JavascriptInterface
            fun getFeedsList(): String {
                try {
                    val worker = UnionWorker.getInstance(CoreUtil.getContext(), null)
                    if (worker.unionCache != null) {
                        val feedVOList = worker.unionCache?.feedVOList
                        val feedDetailList = worker.unionCache?.feedDetailList
                        return handleJsData(feedVOList?.toMutableList(), feedDetailList)
                    }
                } catch (e: Exception) {
                    AdLogUtil.Log().e(Log.getStackTraceString(e))
                }
                AdLogUtil.Log().e("js getFeedsList() -> data is null")
                return ""
            }

            /** 处理feed列表和feed详情数据匹配问题 。  */
            private fun handleJsData(
                feedVOList: MutableList<FeedVO>?,
                feedDetailList: List<FeedDetailVO>?
            ): String {
                try {
                    val startTime = System.currentTimeMillis()
                    if (CollectionUtils.isNotEmpty(feedVOList)
                        && CollectionUtils.isNotEmpty(feedDetailList)
                    ) {
                        val iterator = feedVOList?.iterator()
                        while (iterator?.hasNext() == true) {
                            val feedVO = iterator.next()
                            for (i in feedDetailList?.indices!!) {
                                if (feedVO.feedCode == feedDetailList[i].feedCode) {
                                    break
                                } else {
                                    if (i == feedDetailList.size - 1) {
                                        iterator.remove()
                                    }
                                }
                            }
                        }
                        AdLogUtil.Log().i(
                            CommonLogUtil.TAG,
                            "-------------time = " + (System.currentTimeMillis() - startTime) + " ,  size = " + feedVOList?.size
                        )
                        return Gson().toJson(feedVOList)
                    }
                } catch (e: Exception) {
                    AdLogUtil.Log().e(Log.getStackTraceString(e))
                    return Gson().toJson(feedVOList)
                }

                return ""
            }

            /** 获取feeds详情页数据 。  */
            @JavascriptInterface
            fun getFeedsDetail(feedCode: String?): String {
                try {
                    if (TextUtils.isEmpty(feedCode)) return ""

                    val feedDetailVO = getFeedDetailVOList(feedCode)
                    return if (feedDetailVO != null) {
                        Gson().toJson(feedDetailVO)
                    } else {
                        ""
                    }
                } catch (e: Exception) {
                    AdLogUtil.Log().e(Log.getStackTraceString(e))
                }
                AdLogUtil.Log().e("js getFeedsDetail() -> data is null")
                return ""
            }

            /** 获取实验数据 。  */
            @JavascriptInterface
            fun getExperimentList(): String {
                try {
                    val worker = UnionWorker.getInstance(CoreUtil.getContext(), null)
                    if (worker.unionCache != null) {
                        val abTestHitExpVOList = worker.unionCache?.experimentList
                        return if (CollectionUtils.isNotEmpty(abTestHitExpVOList)) {
                            Gson().toJson(abTestHitExpVOList)
                        } else {
                            ""
                        }
                    }
                } catch (e: Exception) {
                    AdLogUtil.Log().e(Log.getStackTraceString(e))
                }
                return ""
            }

            /** 显示无网提醒 。  */
            @JavascriptInterface
            fun showNetTips() {
                ThreadUtils.runOnUiThread {
                    try {
                        showNetTip()
                    } catch (e: Exception) {
                        AdLogUtil.Log().e(Log.getStackTraceString(e))
                    }
                }
            }

            /** 页面完全加载完成的回调 */
            @JavascriptInterface
            fun webViewLoadFinish() {
                try {
                    AthenaTracker.trackWebViewLoadFinish(startTime)
                } catch (e: Exception) {
                    AdLogUtil.Log().e(Log.getStackTraceString(e))
                }
            }
        }
//        ActionWebView.setJsHelper(jsName, UnionJsBridge())
        webView?.addJavascriptInterface(UnionJsBridge(), jsName)
    }

    /**
     * 网络变化的广播
     */
    private class NetBroadcastReceiver(feedsFragment: FeedsFragment) : BroadcastReceiver() {
        private val weakReference: WeakReference<FeedsFragment> = WeakReference(feedsFragment)

        override fun onReceive(context: Context, intent: Intent) {

            val action = intent.action
            if (ConnectivityManager.CONNECTIVITY_ACTION == action) {
                ThreadUtils.runOnUiThreadDelayed({
                    val feedsFragment = weakReference.get() ?: return@runOnUiThreadDelayed
                    if (!CommonUtils.checkNetworkState()) {
                        feedsFragment.showNetTip()
                    }
                }, 800)
            }
        }

    }

    private fun showNetTip() {
        if (PreferencesHelper.instance
                .getBoolean(Constants.KeyName.KEY_CLOSE_NET_TIPS, false)
        ) return
        if (noNetGroup == null || closeNoNetIv == null) return
        AthenaTracker.trackShowNetTip(if (TextUtils.isEmpty(detailUrl)) 1 else 2)
        try {
            noNetGroup?.visibility = View.VISIBLE
            closeNoNetIv?.setOnClickListener {
                AthenaTracker.trackCloseNetTip(if (TextUtils.isEmpty(detailUrl)) 1 else 2)
                PreferencesHelper.instance.putBoolean(Constants.KeyName.KEY_CLOSE_NET_TIPS, true)
                noNetGroup?.visibility = View.GONE
            }
            if (netCountDownTimer != null) {
                netCountDownTimer?.setDownTimerListener(object : DownTimerListener {
                    override fun onTick(millisUntilFinished: Long) {
                        AdLogUtil.Log()
                            .i(CommonLogUtil.TAG, "------onTick ------$millisUntilFinished")
                    }

                    override fun onFinish() {
                        if (noNetGroup != null) noNetGroup?.visibility = View.GONE
                    }
                })
                netCountDownTimer?.start() //启动倒计时
            }
        } catch (e: Exception) {
            AdLogUtil.Log().e(Log.getStackTraceString(e))
        }
    }

    companion object {
        const val jsName = "login"

        /**
         * 返回fragment实例
         *
         * @param url 跳转Url
         * @return
         */
        fun newInstance(url: String?): FeedsFragment {
            val feedsFragment = FeedsFragment()
            val bundle = Bundle()
            bundle.putString(Constants.KeyName.KEY_FEED_DETAIL_URL, url)
            feedsFragment.arguments = bundle
            return feedsFragment
        }
    }

    override fun getStatusLayout(): WebViewLayout? {
        return webViewGroup
    }
}