package com.cloud.baobabsland.utils.gsonutil;

import android.text.TextUtils;
import android.util.Log;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;

public class FloatTypeAdapter extends TypeAdapter<Float> {

    @Override
    public Float read(JsonReader in) throws IOException {
        if (null == in) {
            return null;
        }

        switch (in.peek()) {
            case NUMBER:
                return (float) in.nextDouble();
            case STRING:
                String result = in.nextString();
                if (TextUtils.isEmpty(result)) {
                    return null;
                }

                Float str = null;
                try {
                    str = Float.parseFloat(result);
                } catch (Exception e) {
                    Log.getStackTraceString(e);
                }
                return str;
            default:
                in.skipValue();
                return null;
        }
    }

    @Override
    public void write(JsonWriter out, Float value) throws IOException {
        out.value(value);
    }
}