package com.cloud.baobabsland.webview

import android.content.Context
import android.content.MutableContextWrapper
import android.os.Looper
import com.cloud.baobabsland.utils.AdLogUtil
import com.cloud.baobabsland.utils.CommonLogUtil

/**
 * WebView的缓存容器
 * obtail获取对象
 * recycle回收对象
 */
object WebViewManager {

    private val webViewCache: MutableList<ActionWebView> = ArrayList(1)

    private fun create(context: Context): ActionWebView {
        return ActionWebView(context)
    }

    /**
     * 初始化
     */
    @JvmStatic
    fun prepare(context: Context) {
        if (webViewCache.isEmpty()) {
            Looper.myQueue().addIdleHandler {
                webViewCache.add(create(MutableContextWrapper(context)))
                false
            }
        }
    }

    /**
     * 获取WebView
     */
    @JvmStatic
    fun obtain(context: Context): ActionWebView {

        if (webViewCache.isEmpty()) {
            AdLogUtil.Log().i(CommonLogUtil.TAG, " webViewCache is empty()")
            webViewCache.add(create(MutableContextWrapper(context)))
        } else {
            AdLogUtil.Log().i(CommonLogUtil.TAG, " webViewCache is not empty()")
        }
        val webView = webViewCache.removeFirst()
        val contextWrapper = webView.context as MutableContextWrapper
        contextWrapper.baseContext = context
        return webView
    }

}