package com.cloud.baobabsland.webview.view

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.TextView
import com.cloud.baobabsland.R

class WebViewLayout(context: Context, attributeSet: AttributeSet) : FrameLayout(context, attributeSet) {
    private var mMainLayout: ViewGroup? = null
    var mBtnReload: TextView? = null

    /** 重试监听  */
    private var mListener: OnReloadListener? = null

    private fun initLayout() {
        mMainLayout = LayoutInflater.from(context).inflate(R.layout.union_no_network_layout, this, false) as ViewGroup
        mBtnReload = mMainLayout?.findViewById(R.id.union_error_reload_btn)
        mBtnReload?.setOnClickListener(mClickWrapper)
        addView(mMainLayout)
    }

    fun show() {
        if (mMainLayout == null) {
            //初始化布局
            initLayout()
        }
        if (isShow()) {
            return
        }
        mBtnReload?.visibility = if (mListener == null) INVISIBLE else VISIBLE
        // 显示布局
        mMainLayout?.visibility = VISIBLE
    }

    fun isShow(): Boolean {
        return mMainLayout != null && mMainLayout?.visibility == VISIBLE
    }

    fun hide() {
        if (mMainLayout == null || !isShow()) {
            return
        }
        mMainLayout?.visibility = INVISIBLE
    }


    /**
     * 设置重试监听器
     */
    fun setOnReloadListener(listener: OnReloadListener) {
        mListener = listener
        if (isShow()) {
            mBtnReload?.visibility = if (mListener == null) INVISIBLE else VISIBLE
        }
    }

    private val mClickWrapper = OnClickListener {
        if (mListener == null) {
            return@OnClickListener
        }
        mListener?.onReload(this@WebViewLayout)
    }



    interface OnReloadListener {
        fun onReload(layout: WebViewLayout)
    }
}