package com.cloud.baobabsland.worker.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.util.Log
import com.cloud.baobabsland.constant.Constants
import com.cloud.baobabsland.utils.*
import com.cloud.baobabsland.worker.UnionWorker
import java.lang.Exception
import java.util.*

/**
 * 网络发生改变的广播
 */
class UnionBroadcastReceiver : BroadcastReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        val action = intent.action
        if (ConnectivityManager.CONNECTIVITY_ACTION == action) {
            try {
                ThreadUtils.runOnUiThreadDelayed({
                    AdLogUtil.Log().i(CommonLogUtil.TAG, "network is change    ， netStatus = ${CommonUtils.checkNetworkState()}")
                    if (CommonUtils.checkNetworkState()) {

                        val isUpdateData = PreferencesHelper.isUpdateData(
                            Constants.KeyName.KEY_CONFIG_DAILY,
                            Calendar.getInstance()[Calendar.DAY_OF_MONTH]
                        )
                        if (isUpdateData) {
                            val unionWorker = UnionWorker.getInstance(context, null)
                            unionWorker.checkEmpty(true)
                        } else {
                            AdLogUtil.Log().e("network change time is exceeded times")
                        }
                    }
                }, 800)

            } catch (e: Exception) {
                AdLogUtil.Log().e(Log.getStackTraceString(e))
            }
        }
    }
}