/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.baobabsland.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.content.FileProvider;
import com.cloud.baobabsland.utils.AdLogUtil;
import com.cloud.baobabsland.utils.Md5Utils;
import com.transsion.core.CoreUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/cloud/baobabsland/utils/FileUtils;", "", "()V", "Companion", "baobabsland-sdk_release"})
public final class FileUtils {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final String MODE_READ_ONLY = "r";
    @NotNull
    private static final String EXT_STORAGE_PATH;
    @NotNull
    private static final String EXT_STORAGE_DIR;
    @NotNull
    private static final String APP_EXT_STORAGE_PATH;
    @NotNull
    private static final String EXT_DOWNLOADS_PATH;
    @NotNull
    private static final String EXT_PICTURES_PATH;
    @NotNull
    private static final String EXT_DCIM_PATH;

    private FileUtils() {
    }

    @JvmStatic
    public static final void close(Closeable ... closeableArray) {
        Companion.close(closeableArray);
    }

    static {
        String string;
        Companion = new Companion(null);
        EXT_STORAGE_PATH = string = FileUtils.Companion.getExtStoragePath();
        EXT_STORAGE_DIR = string = string + File.separator;
        APP_EXT_STORAGE_PATH = string + "Android";
        EXT_DOWNLOADS_PATH = FileUtils.Companion.getExtDownloadsPath();
        EXT_PICTURES_PATH = FileUtils.Companion.getExtPicturesPath();
        EXT_DCIM_PATH = FileUtils.Companion.getExtDCIMPath();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f0\u001e\"\u0004\u0018\u00010\u001fH\u0007\u00a2\u0006\u0002\u0010 J%\u0010!\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f0\u001e\"\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010'2\b\u0010)\u001a\u0004\u0018\u00010\u0004J\u0012\u0010*\u001a\u0004\u0018\u00010+2\b\u0010&\u001a\u0004\u0018\u00010'J\u001a\u0010,\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020'H\u0003J\u0014\u0010.\u001a\u0004\u0018\u00010#2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0014\u0010/\u001a\u0004\u0018\u00010#2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u00100\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010'J\u0012\u00100\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u00101\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u00102\u001a\u00020\u00192\b\u00103\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00010'J\u0012\u00104\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u00104\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0012\u00105\u001a\u00020\u00192\b\u00106\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006:"}, d2={"Lcom/cloud/baobabsland/utils/FileUtils$Companion;", "", "()V", "APP_EXT_STORAGE_PATH", "", "EXT_DCIM_PATH", "EXT_DOWNLOADS_PATH", "EXT_PICTURES_PATH", "EXT_STORAGE_DIR", "EXT_STORAGE_PATH", "MODE_READ_ONLY", "contentResolver", "Landroid/content/ContentResolver;", "getContentResolver", "()Landroid/content/ContentResolver;", "extDCIMPath", "getExtDCIMPath", "()Ljava/lang/String;", "extDownloadsPath", "getExtDownloadsPath", "extPicturesPath", "getExtPicturesPath", "extStoragePath", "getExtStoragePath", "isScopedStorageMode", "", "()Z", "close", "", "closeables", "", "Ljava/io/Closeable;", "([Ljava/io/Closeable;)V", "closeIOQuietly", "getDownloadContentUri", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "getFileByPath", "filePath", "getFileInputStream", "Ljava/io/InputStream;", "getMediaContentUri", "mediaFile", "getUriByFile", "getUriForFile", "isFileExists", "isFileExistsApi29", "isFileValid", "originalMd5", "isPublicPath", "isSpace", "s", "openAssetFileDescriptor", "Landroid/content/res/AssetFileDescriptor;", "uri", "baobabsland-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFileExists(String string) {
            File file = this.getFileByPath(string);
            if (file == null) {
                return false;
            }
            return file.exists() ? true : this.isFileExistsApi29(string);
        }

        private final boolean isFileExistsApi29(String string) {
            if (Build.VERSION.SDK_INT >= 29) {
                Closeable[] closeableArray;
                block6: {
                    String string2 = string;
                    string = null;
                    string = closeableArray.openAssetFileDescriptor(Uri.parse((String)string2));
                    if (string != null) break block6;
                    Closeable[] closeableArray2 = closeableArray;
                    Closeable[] closeableArray3 = new Closeable[1];
                    closeableArray = closeableArray3;
                    closeableArray3[0] = string;
                    super.closeIOQuietly(closeableArray);
                    return false;
                }
                Closeable[] closeableArray4 = closeableArray;
                Closeable[] closeableArray5 = closeableArray;
                Closeable[] closeableArray6 = new Closeable[1];
                try {
                    closeableArray6[0] = string;
                    super.closeIOQuietly(closeableArray6);
                }
                catch (Throwable throwable) {
                    Closeable[] closeableArray7 = closeableArray;
                    Closeable[] closeableArray8 = new Closeable[1];
                    closeableArray = closeableArray8;
                    closeableArray8[0] = string;
                    super.closeIOQuietly(closeableArray);
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Closeable[] closeableArray9 = closeableArray;
                    Closeable[] closeableArray10 = new Closeable[1];
                    closeableArray = closeableArray10;
                    closeableArray10[0] = string;
                    super.closeIOQuietly(closeableArray);
                    return false;
                }
                super.closeIOQuietly(new Closeable[]{string});
                return true;
            }
            return false;
        }

        private final Uri getUriByFile(File file) {
            Uri uri;
            if (file == null) {
                return null;
            }
            if (companion.isScopedStorageMode() && companion.isPublicPath(file)) {
                Companion companion;
                String string = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath");
                if (StringsKt.startsWith$default((String)string, (String)EXT_DOWNLOADS_PATH, (boolean)false, (int)2, null)) {
                    Companion companion2 = companion;
                    companion = CoreUtil.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)companion, (String)"getContext()");
                    uri = companion2.getDownloadContentUri((Context)companion, file);
                } else if (!StringsKt.startsWith$default((String)string, (String)EXT_PICTURES_PATH, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)string, (String)EXT_DCIM_PATH, (boolean)false, (int)2, null)) {
                    uri = companion.getUriForFile(file);
                } else {
                    Companion companion3 = companion;
                    companion = CoreUtil.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)companion, (String)"getContext()");
                    uri = companion3.getMediaContentUri((Context)companion, file);
                }
            } else {
                uri = companion.getUriForFile(file);
            }
            return uri;
        }

        private final Uri getUriForFile(File file) {
            if (file == null) {
                return null;
            }
            return Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)CoreUtil.getContext(), (String)(CoreUtil.getContext().getPackageName() + ".updateFileProvider"), (File)file) : Uri.fromFile((File)file);
        }

        @SuppressLint(value={"Range"})
        private final Uri getMediaContentUri(Context context, File file) {
            Object object;
            block12: {
                ContentValues contentValues;
                Uri uri;
                block11: {
                    Context context2 = context;
                    object = file.getAbsolutePath();
                    uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    ContentResolver contentResolver = context2.getContentResolver();
                    Uri uri2 = uri;
                    String[] stringArray = new String[1];
                    String[] stringArray2 = stringArray;
                    stringArray[0] = "_id";
                    Cursor cursor = contentResolver.query(uri2, stringArray2, "_data=? ", new String[]{object}, null);
                    if (cursor == null) break block11;
                    if (!cursor.moveToFirst()) break block11;
                    Uri uri3 = uri;
                    Cursor cursor2 = cursor;
                    Cursor cursor3 = cursor2;
                    int n = cursor2.getInt(cursor2.getColumnIndex("_id"));
                    cursor3.close();
                    object = Uri.withAppendedPath((Uri)uri3, (String)("" + n));
                }
                if (!file.exists()) break block12;
                Context context3 = context;
                context = contentValues;
                try {
                    new ContentValues().put("_data", (String)object);
                    return context3.getContentResolver().insert(uri, (ContentValues)context);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    object = null;
                }
            }
            object = null;
            return object;
        }

        private final boolean isScopedStorageMode() {
            return Build.VERSION.SDK_INT >= 29 && !Environment.isExternalStorageLegacy();
        }

        private final boolean isPublicPath(File file) {
            if (file == null) {
                return false;
            }
            try {
                String string = file.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.canonicalPath");
                return this.isPublicPath(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isPublicPath(String string) {
            if (this.isSpace(string)) {
                return false;
            }
            if (!StringsKt.startsWith$default((String)string, (String)EXT_STORAGE_PATH, (boolean)false, (int)2, null)) return false;
            if (StringsKt.startsWith$default((String)string, (String)APP_EXT_STORAGE_PATH, (boolean)false, (int)2, null)) return false;
            return true;
        }

        private final boolean isSpace(String string) {
            if (string == null) {
                return true;
            }
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private final void closeIOQuietly(Closeable ... closeableArray) {
            for (Closeable closeable : closeableArray) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }

        private final ContentResolver getContentResolver() {
            ContentResolver contentResolver = CoreUtil.getContext().getContentResolver();
            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContext().contentResolver");
            return contentResolver;
        }

        private final String getExtStoragePath() {
            String string = Environment.getExternalStorageDirectory().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalStorageDirectory().absolutePath");
            return string;
        }

        private final String getExtDownloadsPath() {
            String string = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalStoragePublic\u2026            .absolutePath");
            return string;
        }

        private final String getExtPicturesPath() {
            String string = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalStoragePublic\u2026            .absolutePath");
            return string;
        }

        private final String getExtDCIMPath() {
            String string = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalStoragePublic\u2026            .absolutePath");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @Nullable
        public final File getFileByPath(@Nullable String string) {
            Object object;
            boolean bl = string == null || StringsKt.isBlank((CharSequence)string);
            if (bl) {
                return null;
            }
            if (((Companion)object).isSpace(string)) {
                object = null;
            } else {
                File file;
                object = file;
                file = new File(string);
            }
            return object;
        }

        public final boolean isFileExists(@Nullable File file) {
            if (file == null) {
                return false;
            }
            return file.exists() ? true : this.isFileExists(file.getAbsolutePath());
        }

        @Nullable
        public final InputStream getFileInputStream(@Nullable File file) {
            FileInputStream fileInputStream;
            Object object = fileInputStream;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (Exception exception) {
                AdLogUtil.Log().e(Log.getStackTraceString((Throwable)exception));
                object = null;
            }
            return object;
        }

        @SuppressLint(value={"Range"})
        @RequiresApi(api=29)
        @Nullable
        public final Uri getDownloadContentUri(@NotNull Context context, @NotNull File file) {
            Object object;
            block12: {
                ContentValues contentValues;
                Uri uri;
                block11: {
                    File file2 = file;
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    object = file2.getAbsolutePath();
                    uri = MediaStore.Downloads.EXTERNAL_CONTENT_URI;
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"EXTERNAL_CONTENT_URI");
                    ContentResolver contentResolver = context.getContentResolver();
                    Uri uri2 = uri;
                    String[] stringArray = new String[1];
                    String[] stringArray2 = stringArray;
                    stringArray[0] = "_id";
                    Cursor cursor = contentResolver.query(uri2, stringArray2, "_data=? ", new String[]{object}, null);
                    if (cursor == null) break block11;
                    if (!cursor.moveToFirst()) break block11;
                    Uri uri3 = uri;
                    Cursor cursor2 = cursor;
                    Cursor cursor3 = cursor2;
                    int n = cursor2.getInt(cursor2.getColumnIndex("_id"));
                    cursor3.close();
                    object = Uri.withAppendedPath((Uri)uri3, (String)("" + n));
                }
                if (!file.exists()) break block12;
                Context context2 = context;
                context = contentValues;
                try {
                    new ContentValues().put("_data", (String)object);
                    return context2.getContentResolver().insert(uri, (ContentValues)context);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    object = null;
                }
            }
            object = null;
            return object;
        }

        @Nullable
        public final AssetFileDescriptor openAssetFileDescriptor(@Nullable Uri uri) throws FileNotFoundException {
            ContentResolver contentResolver = this.getContentResolver();
            Uri uri2 = uri;
            Intrinsics.checkNotNull((Object)uri2);
            return contentResolver.openAssetFileDescriptor(uri2, FileUtils.MODE_READ_ONLY);
        }

        @JvmStatic
        public final void close(Closeable ... closeableArray) {
            Intrinsics.checkNotNullParameter((Object)closeableArray, (String)"closeables");
            for (Closeable closeable : closeableArray) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        public final boolean isFileValid(@Nullable String string, @Nullable File file) {
            Md5Utils md5Utils = Md5Utils.INSTANCE;
            AdLogUtil.Log().i("baobab", "down load zip  md5 = " + md5Utils.getFileMD5(file) + " \uff0c originalMd5 = " + string);
            return string != null && StringsKt.isBlank((CharSequence)string) ^ true && StringsKt.equals((String)string, (String)md5Utils.getFileMD5(file), (boolean)true);
        }
    }
}

