/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.baobabsland.utils;

import android.os.Handler;
import android.os.Looper;

public final class ThreadUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static Handler getMainHandler() {
        return HANDLER;
    }

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            HANDLER.post(runnable);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l) {
        HANDLER.postDelayed(runnable, l);
    }
}

