/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.baobabsland.utils.gsonutil;

import com.cloud.baobabsland.utils.CommonLogUtil;
import com.cloud.baobabsland.utils.gsonutil.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;

public class GsonUtil {
    public static Gson getGson() {
        return GsonFactory.getSingletonGson();
    }

    public static <T> T fromJson(String string, Class<T> clazz) throws GsonParseException {
        try {
            return (T)GsonUtil.getGson().fromJson(string, clazz);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw new GsonParseException(jsonSyntaxException);
        }
    }

    public static <T> T fromJson(String string, Type type) throws GsonParseException {
        try {
            return (T)GsonUtil.getGson().fromJson(string, type);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw new GsonParseException(jsonSyntaxException);
        }
    }

    public static String toJson(Object object) {
        try {
            return GsonUtil.getGson().toJson(object);
        }
        catch (JsonIOException jsonIOException) {
            CommonLogUtil.Log().e("GsonUtil", jsonIOException.getMessage());
            return "";
        }
    }

    public static class GsonParseException
    extends Exception {
        public GsonParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

